package caveworld.recipe;

import caveworld.item.CaveItems;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class RecipeCavenicBow implements IRecipe
{
	private final ItemStack bow;

	public RecipeCavenicBow(ItemStack bow)
	{
		this.bow = bow;
	}

	@Override
	public boolean matches(InventoryCrafting crafting, World world)
	{
		int i = 0;
		boolean flag = false;

		for (int row = 0; row < 3; ++row)
		{
			for (int column = 0; column < 3; ++column)
			{
				if (row != 1 && column == 1 || row == 1 && column != 1)
				{
					ItemStack itemstack = crafting.getStackInRowAndColumn(row, column);

					if (itemstack != null && itemstack.getItem() == CaveItems.cavenium && itemstack.getItemDamage() == 1)
					{
						++i;
					}
				}
				else if (row == 1 && column == 1)
				{
					ItemStack itemstack = crafting.getStackInRowAndColumn(row, column);

					if (itemstack != null && itemstack.getItem() == bow.getItem() && itemstack.getItemDamage() > 0)
					{
						flag = true;
					}
				}
			}
		}

		return i == 4 && flag;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting crafting)
	{
		ItemStack result = getRecipeOutput().copy();
		ItemStack center = crafting.getStackInRowAndColumn(1, 1);

		if (center.hasTagCompound())
		{
			result.setTagCompound((NBTTagCompound)center.getTagCompound().copy());
		}

		return result;
	}

	@Override
	public int getRecipeSize()
	{
		return 9;
	}

	@Override
	public ItemStack getRecipeOutput()
	{
		return bow;
	}
}