/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.OffsetDrawable;
import com.gtnewhorizons.modularui.api.drawable.RotatedDrawable;
import com.gtnewhorizons.modularui.api.drawable.SizedDrawable;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.internal.JsonHelper;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.lwjgl.opengl.GL11;

@FunctionalInterface
public interface IDrawable {
    public static final IDrawable EMPTY = (x, y, width, height, partialTicks) -> {};
    public static final Map<String, Function<JsonObject, IDrawable>> JSON_DRAWABLE_MAP = new HashMap<String, Function<JsonObject, IDrawable>>();

    @SideOnly(value=Side.CLIENT)
    public void draw(float var1, float var2, float var3, float var4, float var5);

    @SideOnly(value=Side.CLIENT)
    default public void draw(Pos2d pos, Size size, float partialTicks) {
        this.draw(pos.x, pos.y, size.width, size.height, partialTicks);
    }

    default public void tick() {
    }

    @SideOnly(value=Side.CLIENT)
    default public void applyThemeColor(int color) {
        GlStateManager.color(Color.getRedF(color), Color.getGreenF(color), Color.getBlueF(color), Color.getAlphaF(color));
    }

    @SideOnly(value=Side.CLIENT)
    default public void applyThemeColor() {
        this.applyThemeColor(Color.WHITE.normal);
    }

    @SideOnly(value=Side.CLIENT)
    public static void applyTintColor(int color) {
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
    }

    default public void rotate(float rotation, float width, float height) {
        GlStateManager.translate(width / 2.0f, height / 2.0f, 0.0f);
        GlStateManager.rotate(rotation, 0.0f, 0.0f, 1.0f);
        GlStateManager.translate(-width / 2.0f, -height / 2.0f, 0.0f);
    }

    default public DrawableWidget asWidget() {
        return new DrawableWidget().setDrawable(this);
    }

    default public IDrawable withOffset(float offsetX, float offsetY, float widthOffset, float heightOffset) {
        return new OffsetDrawable(this, offsetX, offsetY, widthOffset, heightOffset);
    }

    default public IDrawable withOffset(float offsetX, float offsetY) {
        return new OffsetDrawable(this, offsetX, offsetY);
    }

    default public IDrawable withFixedSize(float fixedWidth, float fixedHeight, float offsetX, float offsetY) {
        return new SizedDrawable(this, fixedWidth, fixedHeight, offsetX, offsetY);
    }

    default public IDrawable withFixedSize(float fixedWidth, float fixedHeight) {
        return new SizedDrawable(this, fixedWidth, fixedHeight);
    }

    default public IDrawable withRotationDegree(float rotation) {
        return new RotatedDrawable(this).setRotationDegree(rotation);
    }

    default public IDrawable withRotationRadian(float rotation) {
        return new RotatedDrawable(this).setRotationRadian(rotation);
    }

    default public IDrawable withRotationRadian(double rotation) {
        return this.withRotationRadian((float)rotation);
    }

    public static IDrawable ofJson(JsonObject json) {
        Function<JsonObject, IDrawable> function;
        IDrawable drawable = EMPTY;
        if (json.has("type") && (function = JSON_DRAWABLE_MAP.get(json.get("type").getAsString())) != null) {
            drawable = function.apply(json);
        }
        Pos2d offset = JsonHelper.getElement(json, Pos2d.ZERO, Pos2d::ofJson, "offset");
        Size offsetSize = JsonHelper.getElement(json, Size.ZERO, Size::ofJson, "offsetSize");
        Size fixedSize = JsonHelper.getElement(json, Size.ZERO, Size::ofJson, "fixedSize");
        if (!fixedSize.isZero()) {
            return drawable.withFixedSize(fixedSize.width, fixedSize.height, offset.x, offset.y);
        }
        if (!offset.isZero() || !offsetSize.isZero()) {
            return drawable.withOffset(offset.x, offset.y, offsetSize.width, offsetSize.height);
        }
        return drawable;
    }
}

