/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.fluid;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.util.fluid.FluidUtils;
import com.cout970.magneticraft.util.fluid.IFluidTransport;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class FluidPathfinder {
    private List<IFluidTransport> visited = new ArrayList<IFluidTransport>();
    private IFluidTransport from;
    private IFluidTransport to;

    public FluidPathfinder(IFluidTransport from, IFluidTransport to) {
        this.visited.add(from);
        this.from = from;
        this.list(from);
        this.to = to;
    }

    private void list(IFluidTransport f) {
        TileEntity from = f.getTileEntity();
        for (MgDirection dir : MgDirection.values()) {
            IFluidTransport e;
            TileEntity tile = MgUtils.getTileEntity(from, dir);
            if (tile == null || !FluidUtils.isPipe(tile) || !this.from.isCompatible(e = FluidUtils.getFluidTransport(tile)) || !e.canConnectOnSide(dir.opposite()) || !f.canConnectOnSide(dir) || this.visited.contains(e)) continue;
            this.visited.add(e);
            this.list(e);
        }
    }

    public boolean canFluidGoToEnd() {
        return this.to != null && this.visited.contains(this.to);
    }

    public List<IFluidTransport> getPipes() {
        return this.visited;
    }
}

