/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.pole;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricPole;
import com.cout970.magneticraft.api.electricity.IInterPoleWire;
import com.cout970.magneticraft.api.electricity.ITileElectricPole;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.ElectricPoleTier1;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileElectricPoleTier1
extends TileConductorLow
implements ITileElectricPole {
    public ElectricPoleTier1 pole;
    public boolean clientUpdate = false;
    public boolean updateCables = true;
    public boolean locked = false;
    private int ticksUntilUpdate = 0;
    private static final int UPDATE_PAUSE = 100;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void onBlockBreaks() {
        this.pole.disconnectAll();
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        this.updateCables = true;
    }

    @Override
    public void func_145845_h() {
        if (this.ticksUntilUpdate == 0) {
            this.clientUpdate = true;
        }
        this.ticksUntilUpdate = (this.ticksUntilUpdate + 1) % 100;
        super.func_145845_h();
        if (this.updateCables && !this.locked && this.pole.getConnectionMode() == 0) {
            this.findConnections();
            this.updateCables = false;
        }
        this.pole.iterate();
        if (this.clientUpdate) {
            this.clientUpdate = false;
            this.sendUpdateToClient();
        }
    }

    public void findConnections() {
        ElectricPoleTier1.findConnections(this.pole);
        this.clientUpdate = true;
    }

    @Override
    public IElectricConductor[] getConds(VecInt dir, int Vtier) {
        if (VecInt.NULL_VECTOR.equals(dir) && Vtier == 0) {
            return new IElectricConductor[]{this.cond};
        }
        return null;
    }

    @Override
    public IElectricPole getPoleConnection() {
        return this.pole;
    }

    @Override
    public ITileElectricPole getMainTile() {
        return this;
    }

    @Override
    public IElectricConductor initConductor() {
        this.cond = new ElectricConductor(this){

            @Override
            public double getVoltageCapacity() {
                return this.getVoltageMultiplier() * EnergyConverter.RFtoW(0.8);
            }
        };
        this.pole = new ElectricPoleTier1(this, this.cond){

            @Override
            public void onDisconnect(IInterPoleWire conn) {
                super.onDisconnect(conn);
                TileElectricPoleTier1.this.clientUpdate = true;
            }
        };
        return this.cond;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.pole.load(nbt);
        this.locked = nbt.func_74767_n("Locked");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.pole.save(nbt);
        nbt.func_74757_a("Locked", this.locked);
    }
}

