/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.multiblock.controllers;

import com.cout970.magneticraft.api.access.RecipeOilDistillery;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileRefineryTank;
import com.cout970.magneticraft.tileentity.multiblock.TileMB_Base;
import com.cout970.magneticraft.tileentity.multiblock.TileMB_Energy_Low;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.tile.AverageBar;
import com.cout970.magneticraft.util.tile.MachineElectricConductor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileOilDistillery
extends TileMB_Base
implements IGuiSync,
IElectricTile {
    public int drawCounter;
    public IElectricConductor side1;
    public IElectricConductor side2;
    public IElectricConductor own = new MachineElectricConductor(this);
    private TankMg input;
    private TankMg output;
    private double[] flow = new double[3];
    private AverageBar consumption = new AverageBar(20);
    private AverageBar production = new AverageBar(20);
    private AverageBar energy = new AverageBar(20);
    private double maxCost;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        this.consumption.tick();
        this.production.tick();
        this.energy.tick();
        if (this.input == null || this.output == null || this.side1 == null || this.side2 == null) {
            this.search();
        } else {
            RecipeOilDistillery recipe;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            this.valance(this.side1, this.side2, 0);
            this.valance(this.side1, this.own, 1);
            this.valance(this.own, this.side2, 2);
            this.own.recache();
            this.own.iterate();
            if (this.own.getVoltage() > 60.0 && this.input.getFluidAmount() > 0 && this.output.getSpace() > 0 && (recipe = RecipeOilDistillery.getRecipe(this.input.getFluid())) != null && (MgUtils.areEqual(recipe.getOutput(), this.output.getFluid()) || this.output.getFluid() == null) && this.output.getSpace() >= recipe.getOutput().amount) {
                this.input.drain(recipe.getInput().amount, true);
                this.consumption.addValue(recipe.getInput().amount);
                this.output.fill(recipe.getOutput(), true, false);
                this.production.addValue(recipe.getOutput().amount);
                this.own.drainPower(recipe.getEnergyCost());
                this.maxCost = recipe.getEnergyCost();
                this.energy.addValue((float)recipe.getEnergyCost());
            }
        }
    }

    private void valance(IElectricConductor a, IElectricConductor b, int i) {
        ElectricConductor.valance(a, b, this.flow, i);
    }

    private void search() {
        VecInt vec = this.getDirection().opposite().toVecInt().multiply(2);
        TileEntity t = MgUtils.getTileEntity((TileEntity)this, vec);
        if (t instanceof TileRefineryTank) {
            this.input = ((TileRefineryTank)t).getTank();
            this.input.setAllowInOut(true);
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec = this.getDirection().opposite().toVecInt().add(0, 1, 0))) instanceof TileRefineryTank) {
            this.output = ((TileRefineryTank)t).getTank();
            this.output.setAllowInput(false);
            this.output.setAllowOutput(true);
        }
        vec = this.getDirection().opposite().toVecInt().multiply(2).add(0, -1, 0);
        vec.add(this.getDirection().opposite().step(MgDirection.UP).toVecInt());
        t = MgUtils.getTileEntity((TileEntity)this, vec);
        if (t instanceof TileMB_Energy_Low) {
            this.side1 = ((TileMB_Energy_Low)t).getConds(VecInt.NULL_VECTOR, 0)[0];
        }
        vec = this.getDirection().opposite().toVecInt().multiply(2).add(0, -1, 0);
        vec.add(this.getDirection().opposite().step(MgDirection.DOWN).toVecInt());
        t = MgUtils.getTileEntity((TileEntity)this, vec);
        if (t instanceof TileMB_Energy_Low) {
            this.side2 = ((TileMB_Energy_Low)t).getConds(VecInt.NULL_VECTOR, 0)[0];
        }
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.own.getVoltage());
        craft.func_71112_a(cont, 1, this.own.getStorage());
        if (this.input != null && this.output != null) {
            if (this.input.getFluidAmount() > 0) {
                craft.func_71112_a(cont, 2, this.input.getFluid().getFluidID());
                craft.func_71112_a(cont, 3, this.input.getFluidAmount());
            } else {
                craft.func_71112_a(cont, 2, -1);
            }
            if (this.output.getFluidAmount() > 0) {
                craft.func_71112_a(cont, 4, this.output.getFluid().getFluidID());
                craft.func_71112_a(cont, 5, this.output.getFluidAmount());
            } else {
                craft.func_71112_a(cont, 4, -1);
            }
        }
        craft.func_71112_a(cont, 6, (int)this.consumption.getAverage() * 16);
        craft.func_71112_a(cont, 7, (int)this.production.getAverage() * 16);
        craft.func_71112_a(cont, 8, (int)this.maxCost * 16);
        craft.func_71112_a(cont, 9, (int)this.energy.getAverage() * 16);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.own.setVoltage(value);
                break;
            }
            case 1: {
                this.own.setStorage(value);
                break;
            }
            case 6: {
                this.consumption.setStorage((float)value / 16.0f);
                break;
            }
            case 7: {
                this.production.setStorage((float)value / 16.0f);
                break;
            }
            case 8: {
                this.maxCost = (float)value / 16.0f;
                break;
            }
            case 9: {
                this.energy.setStorage((float)value / 16.0f);
            }
        }
        if (this.input == null || this.output == null) {
            return;
        }
        switch (id) {
            case 2: {
                if (value == -1) {
                    this.input.setFluid(null);
                    break;
                }
                this.input.setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
                break;
            }
            case 3: {
                this.input.getFluid().amount = value;
                break;
            }
            case 4: {
                if (value == -1) {
                    this.output.setFluid(null);
                    break;
                }
                this.output.setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
                break;
            }
            case 5: {
                this.output.getFluid().amount = value;
            }
        }
    }

    @Override
    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.own.load(nbt);
        this.flow[0] = nbt.func_74769_h("Conn1");
        this.flow[1] = nbt.func_74769_h("Conn2");
        this.flow[2] = nbt.func_74769_h("Conn3");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.own.save(nbt);
        nbt.func_74780_a("Conn1", this.flow[0]);
        nbt.func_74780_a("Conn2", this.flow[1]);
        nbt.func_74780_a("Conn3", this.flow[2]);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        VecInt v1 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), -1, -1, 0);
        VecInt v2 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), 1, 1, 2);
        VecInt block = new VecInt(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return VecIntUtil.getAABBFromVectors(v1.add(block), v2.add(block));
    }

    public TankMg getInput() {
        return this.input;
    }

    public TankMg getOutput() {
        return this.output;
    }

    @Override
    public IElectricConductor[] getConds(VecInt dir, int Vtier) {
        if (VecInt.NULL_VECTOR.equals(dir)) {
            return new IElectricConductor[]{this.own};
        }
        return null;
    }

    public IBarProvider getEnergyBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("Consumption %.3fkW", Float.valueOf(TileOilDistillery.this.energy.getStorage() / 1000.0f));
            }

            @Override
            public float getLevel() {
                return TileOilDistillery.this.energy.getStorage();
            }

            @Override
            public float getMaxLevel() {
                return TileOilDistillery.this.maxCost != 0.0 ? (float)TileOilDistillery.this.maxCost : TileOilDistillery.this.energy.getStorage();
            }
        };
    }

    public float getConsumptionRate() {
        return this.consumption.getStorage();
    }

    public float getProductionRate() {
        return this.production.getStorage();
    }
}

