/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.multiblock.controllers;

import com.cout970.magneticraft.api.access.RecipeGrinder;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.tileentity.multiblock.TileMB_Base;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.InventoryUtils;
import com.cout970.magneticraft.util.tile.AverageBar;
import com.cout970.magneticraft.util.tile.MachineElectricConductor;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileGrinder
extends TileMB_Base
implements IInventoryManaged,
ISidedInventory,
IGuiSync {
    public MachineElectricConductor cond = new MachineElectricConductor(this);
    private InventoryComponent inv = new InventoryComponent(this, 4, "Grinder");
    private InventoryComponent in;
    private InventoryComponent out;
    public static final int maxProgress = 100;
    private float progress;
    private double[] flow = new double[2];
    public int drawCounter;
    public float rotation;
    private long time;
    private boolean working;
    private boolean active_w;
    private AverageBar energy = new AverageBar(20);

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.working && !this.isWorking()) {
                this.setActive(true);
            } else if (!this.working && this.isWorking()) {
                this.setActive(false);
            }
        }
        this.energy.tick();
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.catchDrops();
        }
        this.updateConductor();
        if (this.cond.getVoltage() >= 60.0) {
            if (this.canCraft()) {
                double speed = TileConductorLow.getEfficiency(this.cond.getVoltage(), 60.0, 85.0);
                if (speed > 0.0) {
                    this.progress = (float)((double)this.progress + (speed *= 10.0));
                    this.energy.addValue((float)EnergyConverter.RFtoW(speed * 10.0));
                    this.cond.drainPower(EnergyConverter.RFtoW(speed * 10.0));
                    if (this.progress >= 100.0f) {
                        this.craft();
                        this.func_70296_d();
                        this.progress %= 100.0f;
                    }
                }
            } else {
                this.progress = 0.0f;
            }
        }
        this.working = this.energy.getAverage() > 0.0f;
        this.distributeItems();
    }

    private void catchDrops() {
        Object aL;
        EntityItem e;
        ItemStack item;
        if (this.in == null) {
            return;
        }
        MgDirection dir = this.getDirection().opposite();
        VecInt vec1 = new VecInt(this).add(0, 4, 0).add(dir.toVecInt());
        VecInt vec2 = vec1.copy();
        vec1.add(-1, 0, -1);
        vec2.add(2, 1, 2);
        List l = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)vec1.getX(), (double)vec1.getY(), (double)vec1.getZ(), (double)vec2.getX(), (double)vec2.getY(), (double)vec2.getZ()));
        if (l.isEmpty()) {
            return;
        }
        Iterator iterator = l.iterator();
        while (iterator.hasNext() && InventoryUtils.dropIntoInventory(item = (e = (EntityItem)(aL = iterator.next())).func_92059_d(), this.in)) {
            this.field_145850_b.func_72900_e((Entity)e);
            e.func_70106_y();
        }
    }

    private void setActive(boolean b) {
        this.active_w = b;
        this.sendUpdateToClient();
    }

    public boolean isWorking() {
        return this.active_w;
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    public void updateConductor() {
        this.cond.recache();
        this.cond.iterate();
        MgDirection d = MgDirection.getDirection(this.func_145832_p()).opposite();
        VecInt vec = d.toVecInt().add(d.step(MgDirection.UP).toVecInt());
        TileEntity c = MgUtils.getTileEntity((TileEntity)this, vec);
        if (c instanceof IElectricTile) {
            this.valance((IElectricTile)c, 0);
        }
        if ((c = MgUtils.getTileEntity((TileEntity)this, vec = d.toVecInt().add(d.step(MgDirection.DOWN).toVecInt()))) instanceof IElectricTile) {
            this.valance((IElectricTile)c, 1);
        }
    }

    public void valance(IElectricTile c, int i) {
        IElectricConductor[] comp = c.getConds(VecInt.NULL_VECTOR, 0);
        IElectricConductor cond2 = comp[0];
        ElectricConductor.valance(this.cond, cond2, this.flow, i);
    }

    private void distributeItems() {
        MgDirection d;
        VecInt v;
        TileEntity c;
        if (this.in == null && (c = MgUtils.getTileEntity((TileEntity)this, v = (d = MgDirection.getDirection(this.func_145832_p()).opposite()).toVecInt().add(new VecInt(0, 3, 0)))) instanceof IInventoryManaged) {
            this.in = ((IInventoryManaged)c).getInv();
        }
        if (this.out == null && (c = MgUtils.getTileEntity((TileEntity)this, v = (d = MgDirection.getDirection(this.func_145832_p()).opposite()).toVecInt().multiply(2))) instanceof IInventoryManaged) {
            this.out = ((IInventoryManaged)c).getInv();
        }
        if (this.in != null && this.out != null) {
            if (((TileBase)this.in.tile).isControlled()) {
                if (this.getInv().func_70301_a(0) != null) {
                    int s = InventoryUtils.findCombination(this.in, this.getInv().func_70301_a(0));
                    if (s != -1) {
                        InventoryUtils.traspass(this.in, this, s, 0);
                    }
                } else {
                    this.func_70299_a(0, InventoryUtils.getItemStack(this.in));
                }
            }
            if (((TileBase)this.out.tile).isControlled()) {
                for (int i = 0; i < 3; ++i) {
                    int s;
                    if (this.getInv().func_70301_a(i + 1) == null || (s = InventoryUtils.getSlotForStack(this.out, this.getInv().func_70301_a(i + 1))) == -1) continue;
                    InventoryUtils.traspass(this, this.out, i + 1, s);
                }
            }
        }
    }

    private void craft() {
        int i;
        ItemStack a = this.getInv().func_70301_a(0);
        RecipeGrinder r = RecipeGrinder.getRecipe(a);
        assert (r != null);
        this.getInv().func_70299_a(1, InventoryUtils.addition(r.getOutput(), this.getInv().func_70301_a(1)));
        int intents = (int)r.getProb2() + 1;
        for (i = 0; i < intents; ++i) {
            if (!(this.field_145850_b.field_73012_v.nextFloat() <= r.getProb2() - (float)i)) continue;
            this.getInv().func_70299_a(2, InventoryUtils.addition(r.getOutput2(), this.getInv().func_70301_a(2)));
        }
        intents = (int)(r.getProb3() / 100.0f) + 1;
        for (i = 0; i < intents; ++i) {
            if (!(this.field_145850_b.field_73012_v.nextFloat() <= r.getProb3() - (float)i)) continue;
            this.getInv().func_70299_a(3, InventoryUtils.addition(r.getOutput3(), this.getInv().func_70301_a(3)));
        }
        --a.field_77994_a;
        if (a.field_77994_a <= 0) {
            this.getInv().func_70299_a(0, null);
        }
    }

    private boolean canCraft() {
        ItemStack a = this.getInv().func_70301_a(0);
        if (a == null) {
            return false;
        }
        RecipeGrinder r = RecipeGrinder.getRecipe(a);
        if (r == null) {
            return false;
        }
        if (this.getInv().func_70301_a(1) != null && !InventoryUtils.canCombine(r.getOutput(), this.getInv().func_70301_a(1), this.getInv().func_70297_j_())) {
            return false;
        }
        if (this.getInv().func_70301_a(2) != null && !InventoryUtils.canCombine(r.getOutput2(), this.getInv().func_70301_a(2), this.getInv().func_70297_j_())) {
            return false;
        }
        return this.getInv().func_70301_a(3) == null || InventoryUtils.canCombine(r.getOutput3(), this.getInv().func_70301_a(3), this.getInv().func_70297_j_());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.active_w = nbt.func_74767_n("Act");
        this.cond.load(nbt);
        this.getInv().readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("Act", this.active_w);
        this.cond.save(nbt);
        this.getInv().writeToNBT(nbt);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, (int)this.energy.getAverage() * 16);
        craft.func_71112_a(cont, 3, (int)this.progress);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.cond.setVoltage(value);
                break;
            }
            case 1: {
                this.energy.setStorage((float)value / 16.0f);
                break;
            }
            case 3: {
                this.progress = value;
            }
        }
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        this.cond.disconnect();
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        VecInt v1 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), -1, -1, 0);
        VecInt v2 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), 1, 3, 2);
        VecInt block = new VecInt(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return VecIntUtil.getAABBFromVectors(v1.add(block), v2.add(block));
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return this.time - aux;
    }

    public IBarProvider getProgressBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return null;
            }

            @Override
            public float getMaxLevel() {
                return 100.0f;
            }

            @Override
            public float getLevel() {
                return TileGrinder.this.progress;
            }
        };
    }

    public IBarProvider getConsumptionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("Consumption %.3f kW", Float.valueOf(TileGrinder.this.energy.getStorage() / 1000.0f));
            }

            @Override
            public float getLevel() {
                return TileGrinder.this.energy.getStorage();
            }

            @Override
            public float getMaxLevel() {
                return (float)EnergyConverter.RFtoW(100.0);
            }
        };
    }
}

