/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.ConnectionClass;
import com.cout970.magneticraft.api.util.IConnectable;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.tileentity.TileBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileTransformerLow_Medium
extends TileBase
implements IElectricTile {
    public IElectricConductor low = new ElectricConductor(this, 0.01){

        @Override
        public boolean isAbleToConnect(IConnectable e, VecInt v) {
            return v.toMgDirection() == MgDirection.getDirection(TileTransformerLow_Medium.this.func_145832_p()) && (e.getConnectionClass(v.getOpposite()) == ConnectionClass.FULL_BLOCK || e.getConnectionClass(v.getOpposite()) == ConnectionClass.CABLE_LOW);
        }

        @Override
        public ConnectionClass getConnectionClass(VecInt v) {
            return ConnectionClass.CABLE_LOW;
        }
    };
    public IElectricConductor medium = new ElectricConductor(this, 1, 0.01){

        @Override
        public double getVoltageCapacity() {
            return 0.06944444444444445;
        }
    };
    public double flow;

    @Override
    public IElectricConductor[] getConds(VecInt dir, int tier) {
        if (VecInt.NULL_VECTOR.equals(dir)) {
            IElectricConductor[] iElectricConductorArray;
            if (tier == 0) {
                IElectricConductor[] iElectricConductorArray2 = new IElectricConductor[1];
                iElectricConductorArray = iElectricConductorArray2;
                iElectricConductorArray2[0] = this.low;
            } else if (tier == 1) {
                IElectricConductor[] iElectricConductorArray3 = new IElectricConductor[1];
                iElectricConductorArray = iElectricConductorArray3;
                iElectricConductorArray3[0] = this.medium;
            } else {
                iElectricConductorArray = null;
            }
            return iElectricConductorArray;
        }
        MgDirection d = dir.toMgDirection();
        if (d == MgDirection.getDirection(this.func_145832_p()) && tier == 0) {
            return new IElectricConductor[]{this.low};
        }
        if (d == MgDirection.getDirection(this.func_145832_p()).opposite() && tier == 1) {
            return new IElectricConductor[]{this.medium};
        }
        return null;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.low.recache();
        this.medium.recache();
        for (int i = 0; i < 2; ++i) {
            this.low.iterate();
            this.medium.iterate();
            double resistence = this.low.getResistance() + this.medium.getResistance();
            double difference = this.low.getVoltage() * (this.medium.getVoltageMultiplier() / this.low.getVoltageMultiplier()) - this.medium.getVoltage();
            double change = this.flow;
            double slow = change * resistence;
            this.flow += (difference - slow) * this.medium.getIndScale() / this.medium.getVoltageMultiplier();
            this.low.applyCurrent(-(change += difference * 0.5 / this.medium.getVoltageMultiplier()));
            this.medium.applyCurrent(change);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound nbtl = nbt.func_74775_l("c1");
        NBTTagCompound nbtm = nbt.func_74775_l("c2");
        this.low.load(nbtl);
        this.medium.load(nbtm);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound nbtl = new NBTTagCompound();
        this.low.save(nbtl);
        NBTTagCompound nbtm = new NBTTagCompound();
        this.medium.save(nbtm);
        nbt.func_74782_a("c1", (NBTBase)nbtl);
        nbt.func_74782_a("c2", (NBTBase)nbtm);
        nbt.func_74780_a("Flow", this.flow);
    }
}

