/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.access.IThermophileDecay;
import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.ThermophileFuel;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class TileThermopile
extends TileConductorLow
implements IGuiSync {
    public int ticks;
    public double diff;
    public int tempHot;
    public int tempCold;

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cond.getVoltage() <= 100.0 && this.isControlled()) {
            ++this.ticks;
            if (this.ticks > 20) {
                this.ticks = 0;
                this.updateTemps();
            }
            this.cond.applyPower(this.getCurrentFromDiff());
        }
    }

    public double getCurrentFromDiff() {
        return EnergyConverter.RFtoW(this.diff / 10.0);
    }

    private void updateTemps() {
        this.tempHot = 0;
        this.tempCold = 0;
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        for (MgDirection d : MgDirection.VALID_DIRECTIONS) {
            Block bl = this.field_145850_b.func_147439_a(this.field_145851_c + d.getOffsetX(), this.field_145848_d + d.getOffsetY(), this.field_145849_e + d.getOffsetZ());
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c + d.getOffsetX(), this.field_145848_d + d.getOffsetY(), this.field_145849_e + d.getOffsetZ());
            BlockInfo b = new BlockInfo(bl, meta, this.field_145851_c + d.getOffsetX(), this.field_145848_d + d.getOffsetY(), this.field_145849_e + d.getOffsetZ());
            list.add(b);
            this.tempHot = (int)((double)this.tempHot + this.getHeat(b));
            this.tempCold = (int)((double)this.tempCold + this.getCold(b));
        }
        this.diff = Math.min(this.tempHot, this.tempCold);
        for (IThermophileDecay t : MgRecipeRegister.thermopileDecays) {
            t.onCheck(this.field_145850_b, list, this.tempHot, this.tempCold);
        }
    }

    public double getHeat(BlockInfo b) {
        for (ThermophileFuel f : MgRecipeRegister.thermopileSources) {
            if (!f.heat || !f.source.equals(b)) continue;
            return f.temp;
        }
        return 0.0;
    }

    public double getCold(BlockInfo b) {
        for (ThermophileFuel f : MgRecipeRegister.thermopileSources) {
            if (f.heat || !f.source.equals(b)) continue;
            return f.temp;
        }
        return 0.0;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.diff * 1000);
        craft.func_71112_a(cont, 1, this.tempHot);
        craft.func_71112_a(cont, 2, this.tempCold);
        craft.func_71112_a(cont, 3, (int)this.cond.getVoltage());
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.diff = (double)value / 1000.0;
        } else if (id == 1) {
            this.tempHot = value;
        } else if (id == 2) {
            this.tempCold = value;
        } else if (id == 3) {
            this.cond.setVoltage(value);
        }
    }

    public double getMaxCurrentFromDiff() {
        return EnergyConverter.RFtoW(20.0);
    }
}

