/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.block.BlockSprinkler;
import com.cout970.magneticraft.compat.ManagerIntegration;
import com.cout970.magneticraft.entity.LiquidSprayFX;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.fluid.TankMg;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.apache.commons.lang3.tuple.Pair;

public class TileSprinkler
extends TileBase
implements IFluidHandler1_8 {
    public static Map<Fluid, FertilizerInfo> fertilizers = new HashMap<Fluid, FertilizerInfo>();
    public static int MAX_RADIUS = 3;
    public static int MAX_HEIGHT = 7;
    public static int MAX_DIAMETER = 2 * MAX_RADIUS + 1;
    public static int MAX_AREA = MAX_DIAMETER * MAX_DIAMETER;
    public static int CONSUMPTION = 1;
    public static int MAX_CONSUMPTION = MAX_AREA * CONSUMPTION;
    public static int PRECISION = MAX_RADIUS == 0 ? 1 : 1 << (int)Math.ceil(Math.log(MAX_RADIUS) / Math.log(2.0) + 1.0);
    private Map<Pair<Integer, Integer>, Integer> heightmapPlants = new HashMap<Pair<Integer, Integer>, Integer>();
    private Map<Pair<Integer, Integer>, Integer> heightmapFarms = new HashMap<Pair<Integer, Integer>, Integer>();
    private TankMg tank = new TankMg(this, MAX_CONSUMPTION);
    private boolean shouldRegen = true;
    private Fluid lastFluid = null;
    private int lastAmount = 0;
    private float lastRotation = 0.0f;
    private float lastRender = 0.0f;

    public static int getRadius(int amount) {
        int ret = amount / CONSUMPTION;
        return (int)Math.floor(Math.sqrt(ret) / 2.0 - 0.5);
    }

    public MgDirection getDir() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.lastAmount > 0 && this.field_145850_b.func_82737_E() % 2L == 0L) {
                int lvl = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
                for (int direction = 0; direction < 8; direction += lvl > 0 ? 2 : 1) {
                    int power;
                    int n = power = lvl == 2 ? Math.max(1, TileSprinkler.getRadius(this.lastAmount)) : 1;
                    while (power <= TileSprinkler.getRadius(this.lastAmount)) {
                        double angle = (double)this.lastRotation + Math.PI * (double)direction / 4.0;
                        Vec3 v = Vec3.func_72443_a((double)((0.05 + 0.2 * (double)power) * Math.cos(angle)), (double)(this.field_145847_g == 1 ? 0.0 : 0.0), (double)((0.05 + 0.2 * (double)power) * Math.sin(angle)));
                        LiquidSprayFX fx = new LiquidSprayFX(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.4 + 0.2 * (double)this.field_145847_g, (double)this.field_145849_e + 0.5, 0.5f, 1.0f, v, this.lastFluid);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                        ++power;
                    }
                }
            }
            return;
        }
        if (this.heightmapPlants.isEmpty() || this.heightmapFarms.isEmpty()) {
            this.genHeightMap();
        }
        if (this.tank.getFluidAmount() > 0) {
            this.sprinkle(this.tank.getFluid());
        }
        this.updateFluid(this.tank.getFluid());
        this.tank.setFluid(null);
        if (this.shouldRegen || this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.heightmapPlants.clear();
            this.heightmapFarms.clear();
            this.shouldRegen = false;
        }
    }

    private void updateFluid(FluidStack fluid) {
        Fluid f = fluid == null ? null : fluid.getFluid();
        int amount = fluid == null ? 0 : fluid.amount;
        boolean shouldUpdate = false;
        if (!Objects.equals(f, this.lastFluid)) {
            shouldUpdate = true;
            this.lastFluid = f;
        }
        if (this.lastAmount != amount) {
            shouldUpdate = true;
            this.lastAmount = amount;
        }
        if (shouldUpdate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getActualY() {
        return this.field_145848_d + 1 - this.func_145832_p();
    }

    private void genHeightMap() {
        HashSet<Pair> toCheck = new HashSet<Pair>();
        Pair sprinkler = Pair.of((Object)this.field_145851_c, (Object)this.field_145849_e);
        for (int x = this.field_145851_c - MAX_RADIUS; x <= this.field_145851_c + MAX_RADIUS; ++x) {
            for (int z = this.field_145849_e - MAX_RADIUS; z <= this.field_145849_e + MAX_RADIUS; ++z) {
                if (!MgUtils.isUnobstructed2D(this.field_145850_b, (Pair<Integer, Integer>)sprinkler, (Pair<Integer, Integer>)Pair.of((Object)x, (Object)z), this.getActualY(), this.func_145832_p() == 0, false, PRECISION)) continue;
                toCheck.add(Pair.of((Object)x, (Object)z));
            }
        }
        block2: for (Pair p : toCheck) {
            int x = (Integer)p.getLeft();
            int z = (Integer)p.getRight();
            for (int y = this.getActualY(); y >= this.getActualY() - MAX_HEIGHT; --y) {
                Block b = this.field_145850_b.func_147439_a(x, y, z);
                if (b instanceof BlockSprinkler) continue;
                if (b instanceof IGrowable && b instanceof IPlantable) {
                    this.heightmapPlants.put((Pair<Integer, Integer>)Pair.of((Object)x, (Object)z), y);
                    continue;
                }
                if (b instanceof BlockFarmland) {
                    this.heightmapFarms.put((Pair<Integer, Integer>)Pair.of((Object)x, (Object)z), y);
                    continue block2;
                }
                if (b != null && !this.field_145850_b.func_147437_c(x, y, z)) continue block2;
            }
        }
    }

    private void sprinkle(FluidStack fluid) {
        int radius = TileSprinkler.getRadius(fluid.amount);
        FertilizerInfo info = fertilizers.get(fluid.getFluid());
        for (int x = this.field_145851_c - radius; x <= this.field_145851_c + radius; ++x) {
            for (int z = this.field_145849_e - radius; z <= this.field_145849_e + radius; ++z) {
                Pair coords = Pair.of((Object)x, (Object)z);
                if (this.heightmapFarms.containsKey(coords)) {
                    int y1 = this.heightmapFarms.get(coords);
                    if (this.field_145850_b.func_147439_a(x, y1, z) instanceof BlockFarmland && info.doesHydrate()) {
                        int old = this.field_145850_b.func_72805_g(x, y1, z);
                        this.field_145850_b.func_72921_c(x, y1, z, 7, old == 0 ? 6 : 2);
                    } else {
                        this.shouldRegen = true;
                    }
                }
                if (!this.heightmapPlants.containsKey(coords)) continue;
                int y2 = this.heightmapPlants.get(coords);
                Block crop = this.field_145850_b.func_147439_a(x, y2, z);
                if (crop instanceof IGrowable && crop instanceof IPlantable) {
                    if (!((IGrowable)crop).func_149851_a(this.field_145850_b, x, y2, z, this.field_145850_b.field_72995_K) && !((IGrowable)crop).func_149852_a(this.field_145850_b, this.field_145850_b.field_73012_v, x, y2, z) || !(this.field_145850_b.field_73012_v.nextDouble() < info.getChance())) continue;
                    ((IGrowable)crop).func_149853_b(this.field_145850_b, this.field_145850_b.field_73012_v, x, y2, z);
                    continue;
                }
                this.shouldRegen = true;
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fertilizers.containsKey(fluid) && from.equals((Object)this.getDir().toForgeDir());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public float rotate(float time) {
        float diff = time - this.lastRender;
        this.lastRender = time;
        this.lastRotation = (this.lastRotation + (float)this.lastAmount * diff) % 1000.0f;
        return this.lastRotation;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("lastAmount", this.lastAmount);
        if (this.lastFluid != null) {
            nbt.func_74768_a("fluidID", this.lastFluid.getID());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.lastAmount = nbt.func_74762_e("lastAmount");
        this.lastFluid = nbt.func_74764_b("fluidID") ? FluidRegistry.getFluid((int)nbt.func_74762_e("fluidID")) : null;
    }

    static {
        fertilizers.put(FluidRegistry.WATER, new FertilizerInfo(1.0E-4, true, -1, 0));
        if (ManagerIntegration.MFR) {
            fertilizers.put(FluidRegistry.getFluid((String)"sewage"), new FertilizerInfo(0.01, false, -1, 0));
        }
    }

    public static class FertilizerInfo {
        private final double chance;
        private final boolean doesHydrate;
        private final int potionID;
        private final int potionLength;

        public FertilizerInfo(double bonemealChance, boolean doesHydrate, int potionID, int potionLength) {
            this.chance = bonemealChance;
            this.doesHydrate = doesHydrate;
            this.potionID = potionID;
            this.potionLength = potionLength;
        }

        public double getChance() {
            return this.chance;
        }

        public boolean doesHydrate() {
            return this.doesHydrate;
        }

        public int getPotionID() {
            return this.potionID;
        }

        public boolean hasPotionEffect() {
            return this.potionID != -1;
        }

        public int getPotionLength() {
            return this.potionLength;
        }
    }
}

