/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.concurrency.PathFindingCallable;
import com.cout970.magneticraft.util.concurrency.PathFindingExecutor;
import com.cout970.magneticraft.util.concurrency.ThreadSafeBlockAccess;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.pathfinding.OilPathFinding;
import com.cout970.magneticraft.util.pathfinding.PathFinding;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TilePumpJack
extends TileConductorLow
implements IFluidHandler1_8 {
    private static final int speed = 50;
    public static Block fluidOil;
    public float m;
    public boolean active;
    public float time;
    public TankMg tank = new TankMg(this, 4000);
    private List<VecInt> pipes = new LinkedList<VecInt>();
    private Set<VecInt> oilBlocks = new HashSet<VecInt>();
    private Set<VecInt> fluid = new HashSet<VecInt>();
    private boolean pipesPlaced;
    private boolean foundOilDeposit;
    private int cooldown;
    private int buffer;
    private int lastY = -1;
    private Future<PathFinding> result;

    @Override
    public IElectricConductor[] getConds(VecInt dir, int tier) {
        if (tier != 0) {
            return null;
        }
        if (VecInt.NULL_VECTOR.equals(dir)) {
            return new IElectricConductor[]{this.cond};
        }
        return null;
    }

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this){

            @Override
            public VecInt[] getValidConnections() {
                return new VecInt[]{TilePumpJack.this.getOrientation().toVecInt()};
            }
        };
    }

    public MgDirection getOrientation() {
        return MgDirection.AXIX_Y[this.func_145832_p() % MgDirection.AXIX_Y.length];
    }

    @Override
    public void func_145845_h() {
        boolean working;
        super.func_145845_h();
        boolean bl = working = this.cond.getVoltage() > 60.0;
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (working && !this.isActive()) {
                this.setActive(true);
            } else if (!working && this.isActive()) {
                this.setActive(false);
            }
        }
        if (this.field_145850_b.field_72995_K || !working) {
            return;
        }
        if (fluidOil == null) {
            fluidOil = FluidRegistry.getFluid((String)"oil").getBlock();
        }
        if (!this.foundOilDeposit) {
            if (this.result != null) {
                if (this.result.isDone()) {
                    PathFinding pf = null;
                    try {
                        pf = this.result.get();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    if (pf != null) {
                        if (pf.isDone()) {
                            PathFinding.Result pfResult = pf.getResult();
                            List<VecInt> all = pfResult.getAllScanned();
                            if (!all.isEmpty()) {
                                all.stream().filter(v -> v.getBlock((IBlockAccess)this.field_145850_b) == ManagerBlocks.oilSource).forEach(this.oilBlocks::add);
                                all.stream().filter(v -> v.getBlock((IBlockAccess)this.field_145850_b) == fluidOil).forEach(this.fluid::add);
                                this.lastY = -1;
                                this.foundOilDeposit = true;
                            } else {
                                --this.lastY;
                                this.foundOilDeposit = false;
                            }
                            this.result = null;
                        } else {
                            this.result = PathFindingExecutor.INSTANCE.submit(new PathFindingCallable(pf, PathFindingExecutor.INSTANCE));
                        }
                    } else {
                        this.result = null;
                    }
                }
            } else if (this.field_145850_b.func_82737_E() % 80L == 0L) {
                this.updateOilDeposit();
            }
        } else if (!this.pipesPlaced) {
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                this.placePipes();
            }
        } else if (this.tank.getSpace() > 0 && this.buffer > 0) {
            int i = Math.min(50, this.buffer);
            this.buffer -= this.tank.fill(FluidRegistry.getFluidStack((String)"oil", (int)i), true);
            this.cond.drainPower(EnergyConverter.RFtoW(i));
        } else if (this.buffer < 1) {
            if (!this.fluid.isEmpty()) {
                VecInt b = this.fluid.iterator().next();
                int m = this.field_145850_b.func_72805_g(b.getX(), b.getY(), b.getZ());
                Block bl2 = this.field_145850_b.func_147439_a(b.getX(), b.getY(), b.getZ());
                if (m == 0 && bl2 == fluidOil) {
                    this.field_145850_b.func_147449_b(b.getX(), b.getY(), b.getZ(), Blocks.field_150350_a);
                    this.buffer = 1000;
                }
                this.fluid.remove(b);
            } else if (!this.oilBlocks.isEmpty()) {
                VecInt b = this.oilBlocks.iterator().next();
                int m = this.field_145850_b.func_72805_g(b.getX(), b.getY(), b.getZ());
                if (m > 0) {
                    this.field_145850_b.func_72921_c(b.getX(), b.getY(), b.getZ(), m - 1, 2);
                } else {
                    this.field_145850_b.func_147449_b(b.getX(), b.getY(), b.getZ(), ManagerBlocks.oilSourceDrained);
                    this.oilBlocks.remove(b);
                }
                this.buffer = 1000;
            } else {
                this.foundOilDeposit = false;
            }
        }
        this.export();
    }

    private void updateOilDeposit() {
        int start;
        this.fluid.clear();
        this.oilBlocks.clear();
        for (int i = start = this.lastY == -1 ? this.field_145848_d : this.lastY; i > 0; --i) {
            VecInt pos = new VecInt(this.field_145851_c, i, this.field_145849_e);
            Block b = pos.getBlock((IBlockAccess)this.field_145850_b);
            if (!b.equals(ManagerBlocks.oilSource) && !b.equals(fluidOil) && !b.equals(ManagerBlocks.oilSourceDrained)) continue;
            OilPathFinding pathFinding = new OilPathFinding(ThreadSafeBlockAccess.getAccess(this.field_145850_b), pos);
            this.result = PathFindingExecutor.INSTANCE.submit(new PathFindingCallable(pathFinding, PathFindingExecutor.INSTANCE));
            break;
        }
    }

    private void placePipes() {
        if (this.pipes.isEmpty()) {
            this.findPipeSpots();
            this.pipesPlaced = this.pipes.isEmpty();
        } else {
            VecInt c = this.pipes.iterator().next();
            this.replaceBlock(c.getX(), c.getY(), c.getZ(), ManagerBlocks.concreted_pipe);
            this.cond.drainPower(EnergyConverter.RFtoW(80.0));
            this.pipes.remove(c);
        }
    }

    private void findPipeSpots() {
        this.pipes.clear();
        for (int i = 1; i < this.field_145848_d; ++i) {
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e);
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - i, this.field_145849_e);
            if (b.equals(ManagerBlocks.oilSource) || b.equals(fluidOil)) break;
            if (b != Blocks.field_150350_a && (!MgUtils.isMineableBlock(this.field_145850_b, new BlockInfo(b, meta)) || b == ManagerBlocks.concreted_pipe || b == ManagerBlocks.oilSourceDrained)) continue;
            this.pipes.add(new VecInt(this.field_145851_c, this.field_145848_d - i, this.field_145849_e));
        }
    }

    public void replaceBlock(int x, int y, int z, Block replace) {
        if (this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z) || MgUtils.isMineableBlock(this.field_145850_b, new BlockInfo(this.field_145850_b.func_147439_a(x, y, z), this.field_145850_b.func_72805_g(x, y, z), x, y, z))) {
            Block id = this.field_145850_b.func_147439_a(x, y, z);
            int metadata = this.field_145850_b.func_72805_g(x, y, z);
            ArrayList items = id.getDrops(this.field_145850_b, x, y, z, metadata, 0);
            items.stream().filter(item -> item != null && item.field_77994_a > 0).forEach(item -> {
                MgDirection dir = this.getOrientation().opposite();
                float rx = (float)dir.getOffsetX() + 0.5f;
                float ry = 0.5f;
                float rz = (float)dir.getOffsetZ() + 0.5f;
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + rx), (double)((float)this.field_145848_d + ry), (double)((float)this.field_145849_e + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
                if (item.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
                }
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = 0.0;
                entityItem.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)entityItem);
            });
            this.field_145850_b.func_147449_b(x, y, z, replace);
        }
    }

    private void setActive(boolean b) {
        this.active = b;
        this.sendUpdateToClient();
    }

    public boolean isActive() {
        return this.active;
    }

    private void export() {
        if (this.tank.getFluidAmount() > 0) {
            for (MgDirection d : MgDirection.VALID_DIRECTIONS) {
                TileEntity t = MgUtils.getTileEntity((TileEntity)this, d);
                if (!(t instanceof IFluidHandler)) continue;
                IFluidHandler f = (IFluidHandler)t;
                if (f.canFill(d.toForgeDir(), FluidRegistry.getFluid((String)"oil"))) {
                    int m = f.fill(d.toForgeDir(), this.tank.drain(100, false), true);
                    this.tank.drain(m, true);
                }
                if (this.tank.getFluidAmount() == 0) break;
            }
        }
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg(from, resource.amount, doDrain);
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        return fluid.getName().equals("oil");
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public float getDelta(float partial) {
        float aux = this.time;
        this.time = ((float)this.field_145850_b.func_82737_E() + partial) * 50.0f;
        return this.time - aux;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "oil");
        this.buffer = nbt.func_74762_e("Buffer");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "oil");
        nbt.func_74768_a("Buffer", this.buffer);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        VecInt v1 = VecIntUtil.getRotatedOffset(this.getOrientation().opposite(), 0, 0, 1);
        VecInt v2 = VecIntUtil.getRotatedOffset(this.getOrientation(), 0, 3, 2);
        VecInt block = new VecInt(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return VecIntUtil.getAABBFromVectors(v1.add(block), v2.add(block));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
    }

    public int getConnections() {
        return -1;
    }
}

