/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.BlockMultipart;
import com.cout970.magneticraft.api.heat.HeatUtils;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.tileentity.TileSolarTowerCore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileMirror
extends TileBase {
    public float rotation;
    public float angle;
    public BlockCoord target;
    public float distance;
    public BlockCoord load;

    @Override
    public void func_145845_h() {
        IHeatConductor heat;
        IHeatConductor[] comp;
        TileEntity t;
        super.func_145845_h();
        if (this.load != null) {
            this.setTarget(this.load);
            this.load = null;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.target != null && this.field_145850_b.func_72935_r() && !this.field_145850_b.func_72896_J() && this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e) && !this.field_145850_b.field_73011_w.field_76576_e && (t = this.field_145850_b.func_147438_o(this.target.x, this.target.y, this.target.z)) instanceof TileSolarTowerCore && (comp = HeatUtils.getHeatCond(t, VecInt.NULL_VECTOR)) != null && (heat = comp[0]) != null && heat.getTemperature() < 1200.0) {
            heat.applyCalories(EnergyConverter.RFtoCALORIES(2.0));
        }
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        this.updateAngle();
    }

    public void updateAngle() {
        this.setTarget(this.target);
    }

    public void setTarget(BlockCoord ta) {
        this.target = ta;
        if (this.target != null) {
            this.func_70296_d();
            Vector3 t = new Vector3((double)(this.field_145851_c - this.target.x), (double)(this.field_145848_d - this.target.y), (double)(this.field_145849_e - this.target.z));
            if (this.field_145848_d - this.target.y > 0) {
                this.rotation = 0.0f;
                this.angle = 0.0f;
                return;
            }
            this.distance = (float)(t.x * t.x + t.z * t.z);
            if (this.distance < 400.0f) {
                boolean empty = true;
                for (int h = 0; h < (int)this.distance * 10; ++h) {
                    Block block;
                    int x = (int)Math.floor(-t.x * (double)((float)h / (this.distance * 10.0f)) + (double)this.field_145851_c + 0.5);
                    int y = (int)Math.floor(-t.y * (double)((float)h / (this.distance * 10.0f)) + (double)this.field_145848_d + 0.5);
                    int z = (int)Math.floor(-t.z * (double)((float)h / (this.distance * 10.0f)) + (double)this.field_145849_e + 0.5);
                    if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || x == this.target.x && y == this.target.y && z == this.target.z || this.isTransparent(block = this.field_145850_b.func_147439_a(x, y, z))) continue;
                    empty = false;
                    this.rotation = 0.0f;
                    this.angle = 0.0f;
                    break;
                }
                if (empty) {
                    this.rotation = (float)(Math.toRadians(180.0) + Math.atan2(t.z, t.x));
                    this.angle = (float)(Math.toRadians(180.0) + t.angle(new Vector3(0.0, 1.0, 0.0)));
                } else {
                    this.rotation = 0.0f;
                    this.angle = 0.0f;
                }
            }
        }
    }

    private boolean isTransparent(Block block) {
        return block.func_149688_o() == Material.field_151579_a || Block.func_149680_a((Block)block, (Block)Blocks.field_150359_w) || Block.func_149680_a((Block)block, (Block)Blocks.field_150399_cn) || block instanceof BlockMultipart;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] i = nbt.func_74759_k("Coords");
        if (i != null && i.length == 3) {
            this.load = new BlockCoord(i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.target != null) {
            nbt.func_74783_a("Coords", this.target.intArray());
        } else if (this.load != null) {
            nbt.func_74783_a("Coords", this.load.intArray());
        }
    }
}

