/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.api.computer.IBusWire;
import com.cout970.magneticraft.api.computer.IComputer;
import com.cout970.magneticraft.api.computer.IModuleCPU;
import com.cout970.magneticraft.api.computer.IModuleDiskDrive;
import com.cout970.magneticraft.api.computer.IModuleMemoryController;
import com.cout970.magneticraft.api.computer.IModuleROM;
import com.cout970.magneticraft.api.computer.IPeripheral;
import com.cout970.magneticraft.api.computer.prefab.ModuleCPU_MIPS;
import com.cout970.magneticraft.api.computer.prefab.ModuleDiskDrive;
import com.cout970.magneticraft.api.computer.prefab.ModuleMemoryController;
import com.cout970.magneticraft.api.computer.prefab.ModuleROM;
import com.cout970.magneticraft.api.computer.prefab.MonitorPeripheral;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.BufferedConductor;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.ConnectionClass;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.IConnectable;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.Orientation;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.IClientInformer;
import com.cout970.magneticraft.util.IGuiListener;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.InventoryUtils;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileDroidRED
extends TileConductorLow
implements IComputer,
IGuiSync,
IClientInformer,
IGuiListener,
IBusWire {
    private IModuleMemoryController memory;
    private IModuleDiskDrive floppyDisk;
    private IModuleCPU cpu;
    private IModuleROM rom;
    private InventoryComponent inv = new InventoryComponent(this, 16, "R.E.D.");
    public int droidAction = -1;
    public int droidProgress = -1;
    public boolean activate = true;
    private long time;
    public int drillAnim;
    public InventoryComponent extras = new InventoryComponent(this, 2, "R.E.D."){

        @Override
        public void func_70299_a(int slot, ItemStack itemStack) {
            this.inventory[slot] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
            if (slot == 1 && !((TileDroidRED)TileDroidRED.this).field_145850_b.field_72995_K) {
                TileDroidRED.this.floppyDisk.insertDisk(itemStack);
            }
        }

        @Override
        public int func_70297_j_() {
            return 1;
        }
    };
    public IPeripheral droid = new IPeripheral(){
        public int address = 10;

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void setAddress(int address) {
            this.address = address;
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public String getName() {
            return "RED";
        }

        @Override
        public int readByte(int pointer) {
            return 0;
        }

        @Override
        public void writeByte(int pointer, int data) {
            if (pointer == 1) {
                if (data == 1) {
                    TileDroidRED.this.move(true);
                } else if (data == 2) {
                    TileDroidRED.this.move(false);
                }
            } else if (pointer == 2) {
                TileDroidRED.this.rotate(true, data != 0);
            } else if (pointer == 3) {
                TileDroidRED.this.rotate(false, data != 0);
            } else if (pointer == 4) {
                TileDroidRED.this.mine();
            }
        }

        @Override
        public TileEntity getParent() {
            return TileDroidRED.this;
        }
    };
    public MonitorPeripheral monitor = new MonitorPeripheral(this);

    public void create() {
        this.memory = new ModuleMemoryController(65536, false, 8);
        this.cpu = new ModuleCPU_MIPS();
        this.floppyDisk = new ModuleDiskDrive(this);
        this.rom = new ModuleROM();
        this.cpu.connectMemory(this.memory);
        this.memory.setComputer(this);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.cpu == null) {
            this.create();
        }
        if (this.droidProgress > 0) {
            --this.droidProgress;
        }
        if (this.droidProgress == 0) {
            if (this.droidAction == 0) {
                MgDirection dir = this.getDirection();
                Block b = this.field_145850_b.func_147439_a(this.field_145851_c + dir.getOffsetX(), this.field_145848_d + dir.getOffsetY(), this.field_145849_e + dir.getOffsetZ());
                if (b == this.func_145838_q()) {
                    Orientation ori = this.getOrientation();
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    this.field_145851_c += dir.getOffsetX();
                    this.field_145848_d += dir.getOffsetY();
                    this.field_145849_e += dir.getOffsetZ();
                    this.func_145829_t();
                    this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                    this.setOrientation(ori);
                    this.cond.drainPower(EnergyConverter.RFtoW(10.0));
                    this.func_70296_d();
                    this.onNeigChange();
                    this.sendUpdateToClient();
                }
                this.droidProgress = -1;
                return;
            }
            if (this.droidAction == 1) {
                MgDirection dir = this.getDirection().opposite();
                Block b = this.field_145850_b.func_147439_a(this.field_145851_c + dir.getOffsetX(), this.field_145848_d + dir.getOffsetY(), this.field_145849_e + dir.getOffsetZ());
                if (b == this.func_145838_q()) {
                    Orientation ori = this.getOrientation();
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    this.field_145851_c += dir.getOffsetX();
                    this.field_145848_d += dir.getOffsetY();
                    this.field_145849_e += dir.getOffsetZ();
                    this.func_145829_t();
                    this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                    this.setOrientation(ori);
                    this.cond.drainPower(EnergyConverter.RFtoW(10.0));
                    this.func_70296_d();
                    this.onNeigChange();
                    this.sendUpdateToClient();
                }
                this.droidProgress = -1;
                return;
            }
            if (this.droidAction == 2) {
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                Orientation or = this.getOrientation().rotateY(true);
                this.setOrientation(or);
            } else if (this.droidAction == 3) {
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                Orientation or = this.getOrientation().rotateY(false);
                this.setOrientation(or);
            } else if (this.droidAction == 4) {
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                Orientation or = this.getOrientation();
                if ((or = Orientation.find(or.getLevel() + 1, or.getDirection())) != null) {
                    this.setOrientation(or);
                }
            } else if (this.droidAction == 5) {
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                Orientation or = this.getOrientation();
                if ((or = Orientation.find(or.getLevel() - 1, or.getDirection())) != null) {
                    this.setOrientation(or);
                }
            }
            this.droidProgress = -1;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.cpu.iterate();
        this.floppyDisk.iterate();
        this.cond.drainPower(EnergyConverter.RFtoW(0.5));
    }

    public void rotate(boolean axis, boolean dir) {
        if (axis) {
            if (dir) {
                this.droidProgress = 5;
                this.droidAction = 2;
                this.sendUpdateToClient();
            } else {
                this.droidProgress = 5;
                this.droidAction = 3;
                this.sendUpdateToClient();
            }
        } else if (dir && this.getOrientation().getLevel() != 1) {
            this.droidProgress = 5;
            this.droidAction = 4;
            this.sendUpdateToClient();
        } else if (!dir && this.getOrientation().getLevel() != -1) {
            this.droidProgress = 5;
            this.droidAction = 5;
            this.sendUpdateToClient();
        }
    }

    private void setOrientation(Orientation o) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, o.ordinal(), 3);
    }

    public Orientation getOrientation() {
        return Orientation.fromMeta(this.func_145832_p());
    }

    public void move(boolean front) {
        MgDirection dir;
        MgDirection mgDirection = dir = front ? this.getDirection() : this.getDirection().opposite();
        if (this.func_145838_q().func_149742_c(this.field_145850_b, this.field_145851_c + dir.getOffsetX(), this.field_145848_d + dir.getOffsetY(), this.field_145849_e + dir.getOffsetZ())) {
            this.field_145850_b.func_147465_d(this.field_145851_c + dir.getOffsetX(), this.field_145848_d + dir.getOffsetY(), this.field_145849_e + dir.getOffsetZ(), ManagerBlocks.droid_red, 15, 2);
            if (front) {
                this.droidProgress = 5;
                this.droidAction = 0;
            } else {
                this.droidProgress = 10;
                this.droidAction = 1;
            }
            this.activate = true;
            this.sendUpdateToClient();
            this.func_70296_d();
        }
    }

    public void mine() {
        int metadata;
        MgDirection dire = this.getDirection();
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c + dire.getOffsetX(), this.field_145848_d + dire.getOffsetY(), this.field_145849_e + dire.getOffsetZ());
        if (MgUtils.isMineableBlock(this.field_145850_b, new BlockInfo(b, metadata = this.field_145850_b.func_72805_g(this.field_145851_c + dire.getOffsetX(), this.field_145848_d + dire.getOffsetY(), this.field_145849_e + dire.getOffsetZ())))) {
            ArrayList items = b.getDrops(this.field_145850_b, this.field_145851_c + dire.getOffsetX(), this.field_145848_d + dire.getOffsetY(), this.field_145849_e + dire.getOffsetZ(), metadata, 0);
            this.field_145850_b.func_147480_a(this.field_145851_c + dire.getOffsetX(), this.field_145848_d + dire.getOffsetY(), this.field_145849_e + dire.getOffsetZ(), false);
            items.stream().filter(itemStack -> !InventoryUtils.dropIntoInventory(itemStack, this.getInv())).forEach(itemStack -> BlockMg.dropItem(itemStack, this.field_145850_b.field_73012_v, this.field_145851_c + dire.getOffsetX(), this.field_145848_d + dire.getOffsetY(), this.field_145849_e + dire.getOffsetZ(), this.field_145850_b));
        }
    }

    public MgDirection getDirection() {
        if (this.getOrientation().getLevel() == 1) {
            return MgDirection.UP;
        }
        if (this.getOrientation().getLevel() == -1) {
            return MgDirection.DOWN;
        }
        return this.getOrientation().getDirection().opposite();
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.activate = nbt.func_74767_n("Active");
        this.droidProgress = nbt.func_74762_e("PROGRESS");
        this.droidAction = nbt.func_74762_e("ACTION");
        this.getInv().readFromNBT(nbt);
        this.monitor.load(nbt);
        this.extras.readFromNBT(nbt, "Extras");
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && this.cpu != null) {
            this.cpu.loadRegisters(nbt);
            this.memory.loadMemory(nbt);
            this.floppyDisk.load(nbt);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("Active", this.activate);
        nbt.func_74768_a("PROGRESS", this.droidProgress);
        nbt.func_74768_a("ACTION", this.droidAction);
        this.getInv().writeToNBT(nbt);
        this.monitor.save(nbt);
        this.extras.writeToNBT(nbt, "Extras");
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && this.cpu != null) {
            this.cpu.saveRegisters(nbt);
            this.memory.saveMemory(nbt);
            this.floppyDisk.save(nbt);
        }
    }

    @Override
    public void saveInServer(NBTTagCompound nbt) {
        nbt.func_74757_a("Active", this.activate);
        nbt.func_74768_a("PROGRESS", this.droidProgress);
        nbt.func_74768_a("ACTION", this.droidAction);
        this.getInv().writeToNBT(nbt);
        this.monitor.save(nbt);
        this.extras.writeToNBT(nbt, "Extras");
    }

    @Override
    public void loadInClient(NBTTagCompound nbt) {
        this.activate = nbt.func_74767_n("Active");
        this.droidProgress = nbt.func_74762_e("PROGRESS");
        this.droidAction = nbt.func_74762_e("ACTION");
        this.getInv().readFromNBT(nbt);
        this.monitor.load(nbt);
        this.extras.readFromNBT(nbt, "Extras");
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return this.time - aux;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.cond.getStorage() & 0xFFFF);
        craft.func_71112_a(cont, 2, (this.cond.getStorage() & 0xFFFF0000) >>> 16);
        this.sendUpdateToClient();
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.cond.setVoltage(value);
                break;
            }
            case 1: {
                this.cond.setStorage(value & 0xFFFF);
                break;
            }
            case 2: {
                this.cond.setStorage(this.cond.getStorage() | value << 16);
            }
        }
    }

    @Override
    public IModuleCPU getCPU() {
        return this.cpu;
    }

    @Override
    public IModuleMemoryController getMemory() {
        return this.memory;
    }

    @Override
    public TileEntity getParent() {
        return this;
    }

    @Override
    public IElectricConductor initConductor() {
        return new BufferedConductor(this, 0.01, (int)EnergyConverter.RFtoW(50000.0), 58.333333333333336, 66.66666666666667);
    }

    public boolean isRunning() {
        return true;
    }

    @Override
    public void onMessageReceive(int id, int data) {
        if (id == 0) {
            if (!this.cpu.isRunning()) {
                this.cpu.start();
                this.rom.loadToRAM(this.memory);
                this.sendUpdateToClient();
            }
        } else if (id == 1) {
            this.cpu.stop();
            this.cpu.start();
            this.rom.loadToRAM(this.memory);
            this.sendUpdateToClient();
        } else if (id == 2) {
            this.cpu.stop();
            this.sendUpdateToClient();
        }
    }

    @Override
    public IPeripheral[] getPeripherals() {
        return new IPeripheral[]{this.droid, this.monitor};
    }

    @Override
    public void saveInfoToMessage(NBTTagCompound nbt) {
        this.monitor.saveInfoToMessage(nbt);
    }

    @Override
    public void loadInfoFromMessage(NBTTagCompound nbt) {
        this.monitor.loadInfoFromMessage(nbt);
    }

    @Override
    public VecInt[] getValidConnections() {
        return VecIntUtil.FORGE_DIRECTIONS;
    }

    @Override
    public void iterate() {
    }

    @Override
    public boolean isAbleToConnect(IConnectable cond, VecInt dir) {
        return true;
    }

    @Override
    public ConnectionClass getConnectionClass(VecInt v) {
        return ConnectionClass.FULL_BLOCK;
    }

    @Override
    public void save(NBTTagCompound nbt) {
    }

    @Override
    public void load(NBTTagCompound nbt) {
    }
}

