/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.ManagerConfig;
import com.cout970.magneticraft.api.access.RecipeCrushingTable;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.tileentity.TileBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityBlockDustFX;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileCrushingTable
extends TileBase {
    private ItemStack ore;
    public int progress;
    public int maxProgress;

    @Override
    public void onBlockBreaks() {
        if (this.ore != null) {
            BlockMg.dropItem(this.ore, this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound tag = (NBTTagCompound)nbt.func_74781_a("item");
        this.ore = ItemStack.func_77949_a((NBTTagCompound)tag);
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound tag = new NBTTagCompound();
        if (this.ore != null) {
            this.ore.func_77955_b(tag);
        }
        nbt.func_74782_a("item", (NBTBase)tag);
        nbt.func_74768_a("progress", this.progress);
    }

    public void setInput(ItemStack i) {
        this.ore = i;
        this.func_70296_d();
    }

    public ItemStack getInput() {
        return this.ore;
    }

    public void tick(int maxHits) {
        this.maxProgress = maxHits;
        ++this.progress;
        if (this.field_145850_b.field_72995_K) {
            this.addParticles();
        }
        if (this.progress >= this.maxProgress) {
            this.maxProgress = 0;
            this.progress = 0;
            ItemStack out = this.getOutput();
            this.ore = null;
            if (ManagerConfig.CRUSHING_TABLE_DROPS) {
                if (!this.field_145850_b.field_72995_K) {
                    BlockMg.dropItem(out, this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
                }
            } else {
                this.ore = out.func_77946_l();
            }
        }
    }

    public ItemStack getOutput() {
        RecipeCrushingTable rec = RecipeCrushingTable.getRecipe(this.ore);
        if (rec == null) {
            return null;
        }
        return rec.getOutput().func_77946_l();
    }

    @SideOnly(value=Side.CLIENT)
    private void addParticles() {
        if (this.field_145850_b.field_72995_K) {
            Item item = this.ore.func_77973_b();
            Random rnd = new Random();
            for (int i = 0; i < 20; ++i) {
                float a = (rnd.nextFloat() - 0.5f) * 0.5f;
                float b = (rnd.nextFloat() - 0.5f) * 0.5f;
                float c = (rnd.nextFloat() - 0.5f) * 0.5f;
                if (item instanceof ItemBlock) {
                    Block block = Block.func_149634_a((Item)item);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(new EntityBlockDustFX(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)a, (double)this.field_145848_d + 0.95, (double)this.field_145849_e + 0.5 + (double)c, (double)a * 0.15, (double)0.1f + (double)b * 0.005, (double)c * 0.15, block, 0).func_70541_f(0.4f));
                    continue;
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityBreakingFX(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)a, (double)this.field_145848_d + 0.95, (double)this.field_145849_e + 0.5 + (double)c, (double)a * 0.15, (double)0.1f + (double)b * 0.005, (double)c * 0.15, item, 0));
            }
        }
    }

    public boolean canWork() {
        return this.ore != null && RecipeCrushingTable.getRecipe(this.ore) != null;
    }
}

