/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.IHeatTile;
import com.cout970.magneticraft.api.heat.prefab.HeatConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.tile.AverageBar;
import com.cout970.magneticraft.util.tile.MachineElectricConductor;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileBasicGenerator
extends TileConductorLow
implements IFluidHandler1_8,
IGuiSync,
IInventoryManaged,
IHeatTile {
    private static final float MAX_ENERGY_PRODUCTION = 400.0f;
    public float progress = 0.0f;
    public int maxProgres;
    public int maxHeat = 500;
    public IHeatConductor heat = new HeatConductor(this, 1500.0, 1000.0);
    public AverageBar steamProd = new AverageBar(20);
    public AverageBar electricProd = new AverageBar(20);
    public TankMg steam = new TankMg(this, 4000);
    public TankMg water = new TankMg(this, 2000);
    public static final int speed = 4;
    private InventoryComponent inv = new InventoryComponent(this, 1, "Basic Generator");
    private int oldHeat;
    private boolean working;

    @Override
    public IElectricConductor initConductor() {
        return new MachineElectricConductor(this);
    }

    @Override
    public void func_145845_h() {
        int gas;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.heat.iterate();
        if ((int)this.heat.getTemperature() != this.oldHeat && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.sendUpdateToClient();
            this.oldHeat = (int)this.heat.getTemperature();
        }
        this.steamProd.tick();
        this.electricProd.tick();
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.working && !this.isActive()) {
                this.setActive(true);
            } else if (!this.working && this.isActive()) {
                this.setActive(false);
            }
        }
        if (this.progress > 0.0f && this.heat.getTemperature() < (double)this.maxHeat && this.isControlled()) {
            this.heat.applyCalories(EnergyConverter.FUELtoCALORIES(4.0));
            if (this.progress - 4.0f < 0.0f) {
                this.progress = 0.0f;
                this.working = false;
            } else {
                this.progress -= 4.0f;
            }
        }
        if (this.heat.getTemperature() > 100.0) {
            int change = Math.min(this.water.getFluidAmount(), EnergyConverter.STEAMtoWATER(this.steam.getCapacity() - this.steam.getFluidAmount()));
            if ((change = Math.min(change, 4)) > 0) {
                this.heat.drainCalories(EnergyConverter.WATERtoSTEAM_HEAT(change));
                this.water.drain(change, true);
                this.steam.fill(FluidRegistry.getFluidStack((String)"steam", (int)EnergyConverter.WATERtoSTEAM(change)), true);
                this.steamProd.addValue(EnergyConverter.WATERtoSTEAM(change));
            }
        }
        if ((gas = Math.min(this.steam.getFluidAmount(), (int)EnergyConverter.WtoSTEAM(400.0))) > 0 && this.cond.getVoltage() < 100.0 && this.isControlled()) {
            this.cond.applyPower(EnergyConverter.STEAMtoW(gas));
            this.electricProd.addValue((float)EnergyConverter.STEAMtoW(gas));
            this.steam.drain(gas, true);
        }
        if (this.progress <= 0.0f) {
            ItemStack a = this.getInv().func_70301_a(0);
            if (a != null && this.isControlled()) {
                int fuel = TileEntityFurnace.func_145952_a((ItemStack)a);
                if (fuel > 0 && this.cond.getVoltage() < 100.0 && this.steam.getFluidAmount() < 1) {
                    this.progress = fuel;
                    this.maxProgres = fuel;
                    --a.field_77994_a;
                    if (a.field_77994_a <= 0) {
                        a = a.func_77973_b().getContainerItem(a);
                    }
                    this.getInv().func_70299_a(0, a);
                    this.working = true;
                    this.func_70296_d();
                } else {
                    this.working = false;
                }
            } else {
                this.working = false;
            }
        }
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() - 6, 2);
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74760_g("progres");
        this.heat.load(nbt);
        this.water.readFromNBT(nbt, "water");
        this.steam.readFromNBT(nbt, "steam");
        this.getInv().readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("progres", this.progress);
        this.heat.save(nbt);
        this.water.writeToNBT(nbt, "water");
        this.steam.writeToNBT(nbt, "steam");
        this.getInv().writeToNBT(nbt);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 3, (int)this.progress);
        craft.func_71112_a(cont, 4, this.maxProgres);
        craft.func_71112_a(cont, 5, (int)Math.ceil(this.heat.getTemperature()));
        craft.func_71112_a(cont, 6, this.steam.getFluidAmount());
        craft.func_71112_a(cont, 7, this.water.getFluidAmount());
        craft.func_71112_a(cont, 8, (int)(this.steamProd.getAverage() * 16.0f));
        craft.func_71112_a(cont, 9, (int)(this.electricProd.getAverage() * 16.0f));
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.cond.setVoltage(value);
                break;
            }
            case 3: {
                this.progress = value;
                break;
            }
            case 4: {
                this.maxProgres = value;
                break;
            }
            case 5: {
                this.heat.setTemperature(value);
                break;
            }
            case 6: {
                this.steam.setFluid(FluidRegistry.getFluidStack((String)"steam", (int)value));
                break;
            }
            case 7: {
                this.water.setFluid(FluidRegistry.getFluidStack((String)"water", (int)value));
                break;
            }
            case 8: {
                this.steamProd.setStorage((float)value / 16.0f);
                break;
            }
            case 9: {
                this.electricProd.setStorage((float)value / 16.0f);
            }
        }
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        if (resource != null) {
            if (resource.getFluidID() == FluidRegistry.getFluidID((String)"water")) {
                return this.water.fill(resource, doFill);
            }
            if (resource.getFluidID() == FluidRegistry.getFluidID((String)"steam")) {
                return this.steam.fill(resource, doFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg(from, resource.amount, doDrain);
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        return this.steam.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        return FluidRegistry.WATER == fluid;
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        return FluidRegistry.getFluid((String)"steam") == fluid;
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return new FluidTankInfo[]{this.water.getInfo(), this.steam.getInfo()};
    }

    @Override
    public IHeatConductor[] getHeatCond(VecInt c) {
        return new IHeatConductor[]{this.heat};
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
    }

    public IBarProvider getBurningTimeBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return null;
            }

            @Override
            public float getMaxLevel() {
                return TileBasicGenerator.this.maxProgres;
            }

            @Override
            public float getLevel() {
                return TileBasicGenerator.this.progress;
            }
        };
    }

    public IBarProvider getEnergyProductionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("%dW", (int)TileBasicGenerator.this.electricProd.getStorage());
            }

            @Override
            public float getLevel() {
                return TileBasicGenerator.this.electricProd.getStorage();
            }

            @Override
            public float getMaxLevel() {
                return 400.0f;
            }
        };
    }

    public IBarProvider getSteamProductionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("%.2f mB/t", Float.valueOf(TileBasicGenerator.this.steamProd.getStorage()));
            }

            @Override
            public float getLevel() {
                return TileBasicGenerator.this.steamProd.getStorage();
            }

            @Override
            public float getMaxLevel() {
                return EnergyConverter.WATERtoSTEAM(4);
            }
        };
    }
}

