/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.minetweaker;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipeOilDistillery;
import com.cout970.magneticraft.compat.minetweaker.MgMinetweaker;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.OilDistillery")
public class OilDistillery {
    @ZenMethod
    public static void addRecipe(ILiquidStack in, ILiquidStack out, double cost) {
        FluidStack a = MgMinetweaker.toFluid(in);
        FluidStack b = MgMinetweaker.toFluid(out);
        if (a != null && b != null) {
            RecipeOilDistillery r = new RecipeOilDistillery(a, b, cost);
            MineTweakerAPI.apply((IUndoableAction)new AddRecipe(r));
        }
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack in) {
        FluidStack f = MgMinetweaker.toFluid(in);
        if (f == null) {
            return;
        }
        RecipeOilDistillery r = RecipeOilDistillery.getRecipe(f);
        if (r == null) {
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(r));
    }

    public static class RemoveRecipe
    implements IUndoableAction {
        private final RecipeOilDistillery r;

        public RemoveRecipe(RecipeOilDistillery r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.oilDistillery.remove(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.r;
        }

        public String describeUndo() {
            return "Re-Adding " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.oilDistillery.add(this.r);
        }
    }

    public static class AddRecipe
    implements IUndoableAction {
        private final RecipeOilDistillery r;

        public AddRecipe(RecipeOilDistillery r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.oilDistillery.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.oilDistillery.remove(this.r);
        }
    }
}

