/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.minetweaker;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipeGrinder;
import com.cout970.magneticraft.compat.minetweaker.MgMinetweaker;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.Grinder")
public class Grinder {
    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out0, IItemStack out1, float prob1, IItemStack out2, float prob2) {
        ItemStack a = MgMinetweaker.toStack(in);
        ItemStack b = MgMinetweaker.toStack(out0);
        ItemStack c = MgMinetweaker.toStack(out1);
        ItemStack d = MgMinetweaker.toStack(out2);
        if (a == null || b == null) {
            return;
        }
        RecipeGrinder r = new RecipeGrinder(a, b, c, prob1, d, prob2);
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        RecipeGrinder r = RecipeGrinder.getRecipe(MgMinetweaker.toStack(input));
        if (r != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(r));
        }
    }

    public static class RemoveRecipe
    implements IUndoableAction {
        private final RecipeGrinder r;

        public RemoveRecipe(RecipeGrinder r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.grinder.remove(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.r;
        }

        public String describeUndo() {
            return "Re-Adding " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.grinder.add(this.r);
        }
    }

    public static class AddRecipe
    implements IUndoableAction {
        private final RecipeGrinder r;

        public AddRecipe(RecipeGrinder r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.grinder.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.grinder.remove(this.r);
        }
    }
}

