/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.minetweaker;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipeCrushingTable;
import com.cout970.magneticraft.compat.minetweaker.MgMinetweaker;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.CrushingTable")
public class CrushingTable {
    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out) {
        ItemStack a = MgMinetweaker.toStack(in);
        ItemStack b = MgMinetweaker.toStack(out);
        if (a == null || b == null) {
            return;
        }
        RecipeCrushingTable r = new RecipeCrushingTable(a, b);
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        RecipeCrushingTable r = RecipeCrushingTable.getRecipe(MgMinetweaker.toStack(input));
        if (r != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(r));
        }
    }

    public static class RemoveRecipe
    implements IUndoableAction {
        private final RecipeCrushingTable r;

        public RemoveRecipe(RecipeCrushingTable r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.crushing_table.remove(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.r;
        }

        public String describeUndo() {
            return "Re-Adding " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.crushing_table.add(this.r);
        }
    }

    public static class AddRecipe
    implements IUndoableAction {
        private final RecipeCrushingTable r;

        public AddRecipe(RecipeCrushingTable r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.crushing_table.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.crushing_table.remove(this.r);
        }
    }
}

