/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui.component;

import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CompScrollBar
implements IGuiComp {
    public GuiPoint posA;
    public GuiPoint posB;
    public int curScroll;
    public int maxScroll;
    public int width;
    public int height;
    public double section;
    private boolean tracking;
    public static ResourceLocation slider = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");

    public CompScrollBar(GuiPoint a, GuiPoint b, int maxScroll) {
        this.posA = a;
        this.posB = b;
        this.width = b.x - a.x;
        this.height = b.y - a.y;
        this.curScroll = 0;
        this.maxScroll = maxScroll;
        this.tracking = false;
        this.recalculateSections();
    }

    public void recalculateSections() {
        this.section = ((float)this.height - 15.0f) / (float)this.maxScroll;
    }

    public int getScroll() {
        return (int)Math.round((double)((float)this.curScroll + 0.0f) / this.section);
    }

    public void setTracking(boolean b) {
        this.tracking = b;
    }

    @Override
    public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
        gui.field_146297_k.func_110434_K().func_110577_a(slider);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(gui.xStart + this.posA.x, gui.yStart + this.curScroll + this.posA.y, 232, 0, this.width, 15);
    }

    @Override
    public void onClick(int mx, int my, int button, GuiBasic gui) {
        if (button == 0 && (mx >= gui.xStart + this.posA.x && mx <= gui.xStart + this.posB.x && my >= gui.yStart + this.posA.y && my <= gui.yStart + this.posB.y || this.tracking)) {
            this.setTracking(true);
            this.curScroll = my - this.posA.y - gui.yStart - 8;
            this.applyScrollBounds();
        }
    }

    @Override
    public boolean onKey(int n, char key, GuiBasic gui) {
        return false;
    }

    @Override
    public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
    }

    public void applyScrollBounds() {
        this.curScroll = Math.min(Math.max(0, this.curScroll), this.height - 15);
    }

    public void onWheel(int direction) {
        if (this.tracking) {
            return;
        }
        this.curScroll = (int)((double)this.curScroll - (double)direction * this.section);
        this.applyScrollBounds();
    }
}

