/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui.component;

import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.util.DefaultEnumMap;
import com.google.common.base.Function;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class CompButton
implements IGuiComp {
    public ResourceLocation texture;
    protected ButtonState curState;
    protected Set<ButtonState> blockedStates;
    protected int width;
    protected int height;
    protected boolean isDown;
    Function<Integer, Boolean> function;
    GuiPoint pos;
    DefaultEnumMap<ButtonState, GuiPoint> uvMap;

    public CompButton(GuiPoint start, int width, int height, GuiPoint uv, String texture, Function<Integer, Boolean> func) {
        this.texture = new ResourceLocation("Magneticraft".toLowerCase() + ":" + texture);
        this.function = func;
        this.pos = start;
        this.curState = ButtonState.NORMAL;
        this.uvMap = new DefaultEnumMap<ButtonState, GuiPoint>(ButtonState.class, uv);
        this.blockedStates = EnumSet.of(ButtonState.DISABLED);
        this.width = width;
        this.height = height;
        this.isDown = false;
    }

    @Override
    public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
        if (!Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)1)) {
            this.isDown = false;
        }
        ButtonState drawState = this.getState(mx, my, tile, gui);
        GuiPoint curUV = this.getUV(drawState);
        gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(gui.xStart + this.pos.x, gui.yStart + this.pos.y, curUV.x, curUV.y, this.width, this.height);
    }

    private GuiPoint getUV(ButtonState drawState) {
        if (!(this.uvMap.containsKey((Object)drawState) && this.uvMap.get((Object)drawState) != null || drawState.parent == null)) {
            return this.getUV(drawState.parent);
        }
        return this.uvMap.getOrDefault((Object)drawState);
    }

    @Override
    public void onClick(int mx, int my, int button, GuiBasic gui) {
        if (GuiBasic.isIn(mx, my, this.pos.x + gui.xStart, this.pos.y + gui.yStart, this.width, this.height) && !this.blockedStates.contains((Object)this.curState) && ((Boolean)this.function.apply((Object)button)).booleanValue()) {
            this.isDown = true;
            gui.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
    }

    public CompButton setUVForState(ButtonState state, GuiPoint uv) {
        this.uvMap.put(state, uv);
        return this;
    }

    public void resetUVForState(ButtonState state) {
        this.uvMap.remove((Object)state);
    }

    public ButtonState getState(int mx, int my, TileEntity tile, GuiBasic gui) {
        if (this.curState == ButtonState.DISABLED) {
            return ButtonState.DISABLED;
        }
        if (this.isDown) {
            return this.curState == ButtonState.ACTIVE ? ButtonState.ACTIVE_DOWN : ButtonState.DOWN;
        }
        if (GuiBasic.isIn(mx, my, this.pos.x + gui.xStart, this.pos.y + gui.yStart, this.width, this.height)) {
            return this.curState == ButtonState.ACTIVE ? ButtonState.ACTIVE_HOVER : ButtonState.HOVER;
        }
        return this.curState;
    }

    public CompButton setCurrentState(ButtonState state) {
        this.curState = state;
        return this;
    }

    @Override
    public boolean onKey(int n, char key, GuiBasic gui) {
        return false;
    }

    @Override
    public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
    }

    public CompButton setClickable(ButtonState state, boolean clickable) {
        if (clickable) {
            this.blockedStates.remove((Object)state);
        } else {
            this.blockedStates.add(state);
        }
        return this;
    }

    public static enum ButtonState {
        NORMAL(null),
        HOVER(NORMAL),
        DOWN(HOVER),
        DISABLED(null),
        ACTIVE(null),
        ACTIVE_HOVER(ACTIVE),
        ACTIVE_DOWN(ACTIVE_HOVER),
        HIGHLIGHT(null);

        ButtonState parent;

        private ButtonState(ButtonState parent) {
            this.parent = parent;
        }
    }
}

