/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompFluidRender;
import com.cout970.magneticraft.client.gui.component.CompProgressBar;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.tileentity.multiblock.controllers.TilePolymerizer;
import com.cout970.magneticraft.util.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiPolymerizer
extends GuiBasic {
    public GuiPolymerizer(Container c, TileEntity tile) {
        super(c, tile);
    }

    @Override
    public void initComponents() {
        this.comp.add(new CompBackground(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/polimerizer.png")));
        this.comp.add(new CompHeaterBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/heatbar.png"), new GuiPoint(20, 20)));
        this.comp.add(new CompFluidRender(((TilePolymerizer)this.tile).input, new GuiPoint(41, 25), new GuiPoint(59, 64), new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/tank.png")));
        this.comp.add(new CompProgressBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/progressbar1.png"), new GuiPoint(93, 35), ((TilePolymerizer)this.tile).getProgressBar()));
    }

    public class CompHeaterBar
    implements IGuiComp {
        public ResourceLocation texture;
        public GuiPoint pos;

        public CompHeaterBar(ResourceLocation tex, GuiPoint p) {
            this.texture = tex;
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TilePolymerizer) {
                TilePolymerizer ref = (TilePolymerizer)tile;
                IHeatConductor c = ref.heater;
                if (c == null) {
                    return;
                }
                int scale = 0;
                if (c.getMaxTemp() > 0.0) {
                    scale = (int)(c.getTemperature() * 44.0 / c.getMaxTemp());
                }
                if (scale > 44) {
                    scale = 44;
                }
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
            }
        }

        @Override
        public void onClick(int mx, int my, int button, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TilePolymerizer) {
                TilePolymerizer ref = (TilePolymerizer)tile;
                IHeatConductor c = ref.heater;
                if (c == null) {
                    return;
                }
                if (GuiBasic.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 6, 44)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add((int)c.getTemperature() + "C");
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }
}

