/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.pressure.prefab;

import com.cout970.magneticraft.api.pressure.IPressureConductor;
import com.cout970.magneticraft.api.pressure.PressureUtils;
import com.cout970.magneticraft.api.pressure.PressurizedFluid;
import com.cout970.magneticraft.api.util.ConnectionClass;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.IConnectable;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PressureConductor
implements IPressureConductor {
    protected TileEntity parent;
    protected double volume;
    protected double temperature;
    protected double moles;
    protected Fluid currentGas;

    public PressureConductor(TileEntity t, double volume) {
        this.parent = t;
        this.volume = volume;
        this.temperature = 293.15;
    }

    @Override
    public TileEntity getParent() {
        return this.parent;
    }

    @Override
    public void iterate() {
        World w = this.parent.func_145831_w();
        if (w.field_72995_K) {
            return;
        }
        if (this.getFluid() == null) {
            return;
        }
        for (VecInt vec : this.getValidConnections()) {
            TileEntity tile = MgUtils.getTileEntity(this.parent, vec);
            if (tile == null) continue;
            List<IPressureConductor> pre = PressureUtils.getPressureCond(tile, vec.getOpposite());
            ArrayList<IPressureConductor> conds = new ArrayList<IPressureConductor>();
            this.filter(pre, conds);
            for (IPressureConductor p : conds) {
                double sum = this.getMoles() + p.getMoles();
                double vol = this.getVolume() + p.getVolume();
                double toMove = sum * (p.getVolume() / vol) - p.getMoles();
                double remaining = sum * (this.getVolume() / vol);
                if (!(toMove > 0.0)) continue;
                PressurizedFluid pack = new PressurizedFluid(this.getFluid(), toMove, this.getTemperature());
                if ((pack = p.moveFluid(pack)) == null) {
                    this.setMoles(remaining);
                    continue;
                }
                this.setMoles(remaining - pack.getAmount());
            }
        }
    }

    public void filter(List<IPressureConductor> data, List<IPressureConductor> result) {
        result.addAll(data.stream().filter(p -> p.getFluid() == null || p.getFluid() == this.getFluid()).collect(Collectors.toList()));
    }

    @Override
    public VecInt[] getValidConnections() {
        return VecIntUtil.FORGE_DIRECTIONS;
    }

    @Override
    public boolean isAbleToConnect(IConnectable cond, VecInt dir) {
        return true;
    }

    @Override
    public ConnectionClass getConnectionClass(VecInt v) {
        return ConnectionClass.FULL_BLOCK;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74780_a("vol", this.volume);
        nbt.func_74780_a("temp", this.temperature);
        nbt.func_74780_a("mol", this.moles);
        if (this.currentGas != null) {
            FluidStack stack = new FluidStack(this.currentGas, 0);
            stack.writeToNBT(nbt);
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.volume = nbt.func_74769_h("vol");
        this.temperature = nbt.func_74769_h("temp");
        this.moles = nbt.func_74769_h("mol");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        if (stack != null) {
            this.currentGas = stack.getFluid();
        }
    }

    @Override
    public double getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(double vol) {
        this.volume = vol;
    }

    @Override
    public double getPressure() {
        return this.moles * this.temperature * 8.3144621 / (this.volume / 1000.0) * 1000.0;
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(double temp) {
        this.temperature = temp;
    }

    @Override
    public void onBlockExplode() {
    }

    @Override
    public double getMoles() {
        return this.moles;
    }

    @Override
    public void setMoles(double moles) {
        this.moles = moles;
    }

    @Override
    public int applyGas(FluidStack gas, boolean doFill) {
        if (gas == null) {
            return 0;
        }
        if (gas.amount == 0) {
            return 0;
        }
        if (!gas.getFluid().isGaseous()) {
            return 0;
        }
        if (this.currentGas == null || gas.getFluid().equals(this.currentGas)) {
            if (!doFill) {
                return gas.amount;
            }
            this.setFluid(gas.getFluid());
            this.setTemperature(this.currentGas.getTemperature());
            this.moles += EnergyConverter.MBtoMOL(gas.amount);
            return gas.amount;
        }
        return 0;
    }

    @Override
    public FluidStack drainGas(int amount, boolean doDrain) {
        if (this.currentGas == null) {
            return null;
        }
        if (amount <= 0) {
            return null;
        }
        int mB = (int)Math.min((double)amount, EnergyConverter.MOLtoMB(this.moles));
        if (mB > 0) {
            if (!doDrain) {
                return new FluidStack(this.currentGas, mB);
            }
            this.moles -= EnergyConverter.MBtoMOL(mB);
            if (this.moles <= 0.0) {
                this.setTemperature(293.15);
                this.setFluid(null);
            }
            return new FluidStack(this.currentGas, mB);
        }
        return null;
    }

    @Override
    public double getMaxPressure() {
        return EnergyConverter.BARtoPA(200.0);
    }

    @Override
    public Fluid getFluid() {
        return this.currentGas;
    }

    @Override
    public void setFluid(Fluid f) {
        this.currentGas = f;
    }

    @Override
    public PressurizedFluid moveFluid(PressurizedFluid pack) {
        if (pack.getAmount() < 0.0 || pack.getFluid() == null) {
            return pack;
        }
        this.setFluid(pack.getFluid());
        double total = this.getMoles() + pack.getAmount();
        this.setTemperature(this.getTemperature() * (this.getMoles() / total) + pack.getTemperature() * (pack.getAmount() / total));
        this.setMoles(total);
        return null;
    }
}

