/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util.playerdata;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.internal.EntrySet;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.booklet.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.button.BookmarkButton;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

@SideOnly(value=Side.CLIENT)
public class PersistentClientData {
    private static File theFile;

    public static void saveBookPage(GuiBooklet gui) {
        NBTTagCompound baseCompound = PersistentClientData.getBaseCompound();
        NBTTagCompound worldCompound = PersistentClientData.getCompoundForWorld(baseCompound);
        if (worldCompound != null) {
            worldCompound.func_74782_a("SavedEntry", (NBTBase)gui.currentEntrySet.writeToNBT());
            worldCompound.func_74778_a("SearchWord", gui.searchField.func_146179_b());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < gui.bookmarkButtons.length; ++i) {
            BookmarkButton button = (BookmarkButton)gui.bookmarkButtons[i];
            list.func_74742_a((NBTBase)button.assignedEntry.writeToNBT());
        }
        worldCompound.func_74782_a("Bookmarks", (NBTBase)list);
        PersistentClientData.writeCompound(baseCompound, worldCompound);
    }

    private static NBTTagCompound getBaseCompound() {
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(PersistentClientData.getTheFile()));
        }
        catch (Exception e) {
            return new NBTTagCompound();
        }
    }

    private static NBTTagCompound getCompoundForWorld(NBTTagCompound mainCompound) {
        return mainCompound.func_74775_l(PersistentClientData.getName());
    }

    private static void writeCompound(NBTTagCompound baseCompound, NBTTagCompound worldCompound) {
        baseCompound.func_74782_a(PersistentClientData.getName(), (NBTBase)worldCompound);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)baseCompound, (OutputStream)new FileOutputStream(PersistentClientData.getTheFile()));
        }
        catch (Exception e) {
            ModUtil.LOGGER.fatal("Couldn't write Persistent Variable!", (Throwable)e);
        }
    }

    public static File getTheFile() {
        try {
            if (!theFile.exists()) {
                theFile.createNewFile();
            }
        }
        catch (Exception e) {
            ModUtil.LOGGER.fatal("Couldn't create Persistent Variables file!", (Throwable)e);
        }
        return theFile;
    }

    private static String getName() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            return Minecraft.func_71410_x().func_71387_A() ? Minecraft.func_71410_x().func_71401_C().func_71270_I() : Minecraft.func_71410_x().func_147104_D().field_78845_b;
        }
        return "Invalid";
    }

    public static void setTheFile(File file) {
        theFile = file;
    }

    public static void openLastBookPage(GuiBooklet gui) {
        NBTTagCompound worldCompound = PersistentClientData.getCompoundForWorld(PersistentClientData.getBaseCompound());
        if (worldCompound != null) {
            EntrySet set = EntrySet.readFromNBT(worldCompound.func_74775_l("SavedEntry"));
            if (set != null) {
                String searchText;
                BookletUtils.openIndexEntry(gui, set.entry, set.pageInIndex, true);
                if (set.chapter != null) {
                    BookletUtils.openChapter(gui, set.chapter, set.page);
                }
                if (!(searchText = worldCompound.func_74779_i("SearchWord")).isEmpty()) {
                    gui.searchField.func_146180_a(searchText);
                    BookletUtils.updateSearchBar(gui);
                }
            } else {
                BookletUtils.openIndexEntry(gui, null, 1, true);
            }
            NBTTagList list = worldCompound.func_150295_c("Bookmarks", 10);
            if (list != null) {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    BookmarkButton button = (BookmarkButton)gui.bookmarkButtons[i];
                    NBTTagCompound compound = list.func_150305_b(i);
                    button.assignedEntry = EntrySet.readFromNBT(compound);
                }
            }
        }
    }

    public static void setBoolean(String name, boolean bool) {
        NBTTagCompound baseCompound = PersistentClientData.getBaseCompound();
        NBTTagCompound worldCompound = PersistentClientData.getCompoundForWorld(baseCompound);
        if (worldCompound != null) {
            worldCompound.func_74757_a(name, bool);
            PersistentClientData.writeCompound(baseCompound, worldCompound);
        }
    }

    public static boolean getBoolean(String name) {
        NBTTagCompound worldCompound = PersistentClientData.getCompoundForWorld(PersistentClientData.getBaseCompound());
        return worldCompound != null && worldCompound.func_74767_n(name);
    }
}

