/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;

public class ItemUtil {
    public static Item getItemFromName(String name) {
        if (Item.field_150901_e.func_148741_d(name)) {
            return (Item)Item.field_150901_e.func_82594_a(name);
        }
        return null;
    }

    public static boolean contains(ItemStack[] array, ItemStack stack, boolean checkWildcard) {
        return ItemUtil.getPlaceAt(array, stack, checkWildcard) != -1;
    }

    public static int getPlaceAt(ItemStack[] array, ItemStack stack, boolean checkWildcard) {
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                if ((stack != null || array[i] != null) && !ItemUtil.areItemsEqual(stack, array[i], checkWildcard)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2, boolean checkWildcard) {
        return stack1 != null && stack2 != null && (stack1.func_77969_a(stack2) || checkWildcard && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE));
    }

    public static boolean contains(List<ItemStack> list, ItemStack stack, boolean checkWildcard) {
        return list != null && !list.isEmpty() && ItemUtil.getPlaceAt(list.toArray(new ItemStack[list.size()]), stack, checkWildcard) != -1;
    }

    public static void addEnchantment(ItemStack stack, Enchantment e, int level) {
        if (!ItemUtil.hasEnchantment(stack, e)) {
            stack.func_77966_a(e, level);
        }
    }

    public static boolean hasEnchantment(ItemStack stack, Enchantment e) {
        NBTTagList ench = stack.func_77986_q();
        if (ench != null) {
            for (int i = 0; i < ench.func_74745_c(); ++i) {
                short id = ench.func_150305_b(i).func_74765_d("id");
                if (id != e.field_77352_x) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeEnchantment(ItemStack stack, Enchantment e) {
        NBTTagList ench = stack.func_77986_q();
        if (ench != null) {
            for (int i = 0; i < ench.func_74745_c(); ++i) {
                short id = ench.func_150305_b(i).func_74765_d("id");
                if (id != e.field_77352_x) continue;
                ench.func_74744_a(i);
            }
        }
    }
}

