/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.network.PacketParticle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityPhantomface
extends TileEntityInventoryBase
implements IPhantomTile {
    public static final int RANGE = 16;
    public static final float[] COLORS = new float[]{0.3647059f, 0.16862746f, 0.70980394f};
    public Position boundPosition;
    public BlockPhantom.Type type;
    public int range;
    private int rangeBefore;
    private Position boundPosBefore;
    private Block boundBlockBefore;

    public TileEntityPhantomface(String name) {
        super(0, name);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.range = TileEntityPhantomface.upgradeRange(16, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.hasBoundPosition()) {
                this.boundPosition = null;
            }
            if (this.boundPosition != this.boundPosBefore || this.boundPosition != null && this.boundPosition.getBlock(this.field_145850_b) != this.boundBlockBefore || this.rangeBefore != this.range) {
                this.rangeBefore = this.range;
                this.boundPosBefore = this.boundPosition;
                this.boundBlockBefore = this.boundPosition == null ? null : this.boundPosition.getBlock(this.field_145850_b);
                this.func_145831_w().func_147471_g(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                this.func_145831_w().func_147471_g(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                this.sendUpdate();
                this.func_70296_d();
            }
        } else if (this.boundPosition != null) {
            this.renderParticles();
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        compound.func_74768_a("Range", this.range);
        if (this.boundPosition != null) {
            compound.func_74768_a("XCoordOfTileStored", this.boundPosition.getX());
            compound.func_74768_a("YCoordOfTileStored", this.boundPosition.getY());
            compound.func_74768_a("ZCoordOfTileStored", this.boundPosition.getZ());
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        int x = compound.func_74762_e("XCoordOfTileStored");
        int y = compound.func_74762_e("YCoordOfTileStored");
        int z = compound.func_74762_e("ZCoordOfTileStored");
        int world = compound.func_74762_e("WorldOfTileStored");
        this.range = compound.func_74762_e("Range");
        if (x != 0 || y != 0 || z != 0) {
            this.boundPosition = new Position(x, y, z);
            this.func_70296_d();
        }
    }

    public static int upgradeRange(int defaultRange, World world, int x, int y, int z) {
        Block block;
        int newRange = defaultRange;
        for (int i = 0; i < 3 && (block = world.func_147439_a(x, y + 1 + i, z)) == InitBlocks.blockPhantomBooster; ++i) {
            newRange *= 2;
        }
        return newRange;
    }

    @Override
    public boolean hasBoundPosition() {
        if (this.boundPosition != null) {
            if (this.field_145850_b.func_147438_o(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ()) instanceof IPhantomTile || this.field_145851_c == this.boundPosition.getX() && this.field_145848_d == this.boundPosition.getY() && this.field_145849_e == this.boundPosition.getZ()) {
                this.boundPosition = null;
                return false;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles() {
        if (Util.RANDOM.nextInt(2) == 0) {
            double d1 = (float)this.boundPosition.getY() + Util.RANDOM.nextFloat();
            int i1 = Util.RANDOM.nextInt(2) * 2 - 1;
            int j1 = Util.RANDOM.nextInt(2) * 2 - 1;
            double d4 = ((double)Util.RANDOM.nextFloat() - 0.5) * 0.125;
            double d2 = (double)this.boundPosition.getZ() + 0.5 + 0.25 * (double)j1;
            double d5 = Util.RANDOM.nextFloat() * 1.0f * (float)j1;
            double d0 = (double)this.boundPosition.getX() + 0.5 + 0.25 * (double)i1;
            double d3 = Util.RANDOM.nextFloat() * 1.0f * (float)i1;
            this.field_145850_b.func_72869_a("portal", d0, d1, d2, d3, d4, d5);
        }
        if (this.ticksElapsed % 80 == 0) {
            PacketParticle.renderParticlesFromAToB(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ(), 2, 0.35f, COLORS, 3.0f);
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return this.hasBoundPosition() && this.boundPosition.toVec().func_72438_d(Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)) <= (double)this.range;
    }

    @Override
    public Position getBoundPosition() {
        return this.boundPosition;
    }

    @Override
    public void setBoundPosition(Position pos) {
        this.boundPosition = pos == null ? null : pos.copy();
    }

    @Override
    public int getGuiID() {
        return -1;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }
}

