/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketParticle;
import de.ellpeck.actuallyadditions.mod.tile.IRedstoneToggle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPhantomPlacer
extends TileEntityInventoryBase
implements IPhantomTile,
IRedstoneToggle {
    public static final int RANGE = 3;
    public Position boundPosition;
    public int currentTime;
    public int range;
    public boolean isBreaker;
    private boolean activateOnceWithSignal;
    private int oldRange;

    public TileEntityPhantomPlacer(int slots, String name) {
        super(slots, name);
    }

    public TileEntityPhantomPlacer() {
        super(9, "phantomPlacer");
        this.isBreaker = false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.range = TileEntityPhantomface.upgradeRange(3, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.hasBoundPosition()) {
                this.boundPosition = null;
            }
            if (this.isBoundThingInRange() && !this.isRedstonePowered && !this.activateOnceWithSignal) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 30;
                }
            }
            if (this.oldRange != this.range) {
                this.oldRange = this.range;
                this.sendUpdate();
            }
        } else if (this.boundPosition != null) {
            this.renderParticles();
        }
    }

    @Override
    public boolean hasBoundPosition() {
        if (this.boundPosition != null) {
            if (this.field_145850_b.func_147438_o(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ()) instanceof IPhantomTile || this.field_145851_c == this.boundPosition.getX() && this.field_145848_d == this.boundPosition.getY() && this.field_145849_e == this.boundPosition.getZ() && this.field_145850_b.field_73011_w.field_76574_g == this.field_145850_b.field_73011_w.field_76574_g) {
                this.boundPosition = null;
                return false;
            }
            return this.field_145850_b.field_73011_w.field_76574_g == this.field_145850_b.field_73011_w.field_76574_g;
        }
        return false;
    }

    private void doWork() {
        if (this.isBreaker) {
            Block blockToBreak = this.field_145850_b.func_147439_a(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ());
            if (blockToBreak != null && blockToBreak.func_149712_f(this.field_145850_b, this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ()) > -1.0f) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                int meta = this.field_145850_b.func_72805_g(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ());
                drops.addAll(blockToBreak.getDrops(this.field_145850_b, this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ(), meta, 0));
                if (WorldUtil.addToInventory((IInventory)this, drops, false)) {
                    this.field_145850_b.func_72926_e(2001, this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ(), Block.func_149682_b((Block)blockToBreak) + (meta << 12));
                    WorldUtil.breakBlockAtSide(ForgeDirection.UNKNOWN, this.field_145850_b, this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ());
                    WorldUtil.addToInventory((IInventory)this, drops, true);
                    this.func_70296_d();
                }
            }
        } else if (this.field_145850_b.func_147439_a(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ()).isReplaceable((IBlockAccess)this.field_145850_b, this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ())) {
            int theSlot = WorldUtil.findFirstFilledSlot(this.slots);
            this.func_70299_a(theSlot, WorldUtil.placeBlockAtSide(ForgeDirection.UNKNOWN, this.field_145850_b, this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ(), this.slots[theSlot]));
            if (this.slots[theSlot] != null && this.slots[theSlot].field_77994_a <= 0) {
                this.slots[theSlot] = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles() {
        if (Util.RANDOM.nextInt(2) == 0) {
            double d1 = (float)this.boundPosition.getY() + Util.RANDOM.nextFloat();
            int i1 = Util.RANDOM.nextInt(2) * 2 - 1;
            int j1 = Util.RANDOM.nextInt(2) * 2 - 1;
            double d4 = ((double)Util.RANDOM.nextFloat() - 0.5) * 0.125;
            double d2 = (double)this.boundPosition.getZ() + 0.5 + 0.25 * (double)j1;
            double d5 = Util.RANDOM.nextFloat() * 1.0f * (float)j1;
            double d0 = (double)this.boundPosition.getX() + 0.5 + 0.25 * (double)i1;
            double d3 = Util.RANDOM.nextFloat() * 1.0f * (float)i1;
            this.field_145850_b.func_72869_a("portal", d0, d1, d2, d3, d4, d5);
        }
        if (this.ticksElapsed % 80 == 0) {
            PacketParticle.renderParticlesFromAToB(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ(), 2, 0.35f, TileEntityPhantomface.COLORS, 3.0f);
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return this.hasBoundPosition() && this.boundPosition.toVec().func_72438_d(Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)) <= (double)this.range;
    }

    @Override
    public Position getBoundPosition() {
        return this.boundPosition;
    }

    @Override
    public void setBoundPosition(Position pos) {
        this.boundPosition = pos == null ? null : pos.copy();
    }

    @Override
    public int getGuiID() {
        return GuiHandler.GuiTypes.PHANTOM_PLACER.ordinal();
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        compound.func_74768_a("Range", this.range);
        if (this.boundPosition != null) {
            compound.func_74768_a("XCoordOfTileStored", this.boundPosition.getX());
            compound.func_74768_a("YCoordOfTileStored", this.boundPosition.getY());
            compound.func_74768_a("ZCoordOfTileStored", this.boundPosition.getZ());
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        int x = compound.func_74762_e("XCoordOfTileStored");
        int y = compound.func_74762_e("YCoordOfTileStored");
        int z = compound.func_74762_e("ZCoordOfTileStored");
        this.range = compound.func_74762_e("Range");
        if (x != 0 || y != 0 || z != 0) {
            this.boundPosition = new Position(x, y, z);
            this.func_70296_d();
        }
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return !this.isBreaker;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.isBreaker;
    }

    @Override
    public void toggle(boolean to) {
        this.activateOnceWithSignal = to;
    }

    @Override
    public boolean isPulseMode() {
        return this.activateOnceWithSignal;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    public static class TileEntityPhantomBreaker
    extends TileEntityPhantomPlacer {
        public TileEntityPhantomBreaker() {
            super(9, "phantomBreaker");
            this.isBreaker = true;
        }
    }
}

