/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityPhantomLiquiface
extends TileEntityPhantomface
implements IFluidHandler {
    public TileEntityPhantomLiquiface() {
        super("liquiface");
        this.type = BlockPhantom.Type.LIQUIFACE;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.isRedstonePowered && this.isBoundThingInRange() && this.getHandler() != null) {
            this.pushFluid(ForgeDirection.UP);
            this.pushFluid(ForgeDirection.DOWN);
            this.pushFluid(ForgeDirection.NORTH);
            this.pushFluid(ForgeDirection.EAST);
            this.pushFluid(ForgeDirection.SOUTH);
            this.pushFluid(ForgeDirection.WEST);
        }
    }

    public IFluidHandler getHandler() {
        TileEntity tile;
        if (this.boundPosition != null && (tile = this.field_145850_b.func_147438_o(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ())) instanceof IFluidHandler) {
            return (IFluidHandler)tile;
        }
        return null;
    }

    private void pushFluid(ForgeDirection side) {
        TileEntity tile = WorldUtil.getTileEntityFromSide(side, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (tile != null && tile instanceof IFluidHandler && this.getTankInfo(side) != null && this.getTankInfo(side).length > 0 && ((IFluidHandler)tile).getTankInfo(side.getOpposite()) != null && ((IFluidHandler)tile).getTankInfo(side.getOpposite()).length > 0) {
            for (FluidTankInfo myInfo : this.getTankInfo(side)) {
                for (FluidTankInfo hisInfo : ((IFluidHandler)tile).getTankInfo(side.getOpposite())) {
                    FluidStack receive;
                    if (myInfo == null || hisInfo == null || myInfo.fluid == null || myInfo.fluid.getFluid() == null || !((IFluidHandler)tile).canFill(side.getOpposite(), myInfo.fluid.getFluid()) || !this.canDrain(side, myInfo.fluid.getFluid()) || (receive = this.drain(side, Math.min(hisInfo.capacity - (hisInfo.fluid == null ? 0 : hisInfo.fluid.amount), myInfo.fluid.amount), false)) == null) continue;
                    int actualReceive = ((IFluidHandler)tile).fill(side.getOpposite(), receive, true);
                    this.drain(side, new FluidStack(receive.getFluid(), actualReceive), true);
                }
            }
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return super.isBoundThingInRange() && this.field_145850_b.func_147438_o(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ()) instanceof IFluidHandler;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isBoundThingInRange()) {
            return this.getHandler().fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.isBoundThingInRange()) {
            return this.getHandler().drain(from, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.isBoundThingInRange()) {
            return this.getHandler().drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.isBoundThingInRange() && this.getHandler().canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.isBoundThingInRange() && this.getHandler().canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.isBoundThingInRange()) {
            return this.getHandler().getTankInfo(from);
        }
        return new FluidTankInfo[0];
    }
}

