/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.IFluidSaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityOilGenerator
extends TileEntityInventoryBase
implements IEnergyProvider,
IFluidHandler,
IEnergySaver,
IFluidSaver {
    public static final int ENERGY_PRODUCED = 76;
    private static final int BURN_TIME = 100;
    public EnergyStorage storage = new EnergyStorage(50000);
    public FluidTank tank = new FluidTank(2000);
    public int currentBurnTime;
    private int lastEnergy;
    private int lastTank;
    private int lastBurnTime;

    public TileEntityOilGenerator() {
        super(2, "oilGenerator");
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getTankScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurningScaled(int i) {
        return this.currentBurnTime * i / 100;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag;
            boolean bl = flag = this.currentBurnTime > 0;
            if (this.currentBurnTime > 0) {
                --this.currentBurnTime;
                this.storage.receiveEnergy(76, false);
            }
            int fuelUsed = 50;
            if (7600 <= this.getMaxEnergyStored(ForgeDirection.UNKNOWN) - this.getEnergyStored(ForgeDirection.UNKNOWN) && this.currentBurnTime <= 0 && this.tank.getFluidAmount() >= fuelUsed) {
                this.currentBurnTime = 100;
                this.tank.drain(fuelUsed, true);
            }
            WorldUtil.emptyBucket(this.tank, this.slots, 0, 1, InitBlocks.fluidOil);
            if (this.getEnergyStored(ForgeDirection.UNKNOWN) > 0) {
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UP, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.DOWN, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.NORTH, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.EAST, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.SOUTH, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.WEST, this.storage);
            }
            if (flag != this.currentBurnTime > 0) {
                this.func_70296_d();
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (meta == 1) {
                    if (7600 > this.getMaxEnergyStored(ForgeDirection.UNKNOWN) - this.getEnergyStored(ForgeDirection.UNKNOWN) || this.currentBurnTime > 0 || this.tank.getFluidAmount() < fuelUsed) {
                        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
                    }
                } else {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
                }
            }
            if ((this.storage.getEnergyStored() != this.lastEnergy || this.tank.getFluidAmount() != this.lastTank || this.lastBurnTime != this.currentBurnTime) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastTank = this.tank.getFluidAmount();
                this.lastBurnTime = this.currentBurnTime;
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("BurnTime", this.currentBurnTime);
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        super.writeSyncableNBT(compound, sync);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        this.currentBurnTime = compound.func_74762_e("BurnTime");
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        super.readSyncableNBT(compound, sync);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)new FluidStack(InitBlocks.fluidOil, 1000)) && i == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == InitBlocks.fluidOil) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.DOWN && fluid == InitBlocks.fluidOil;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    public FluidStack[] getFluids() {
        return new FluidStack[]{this.tank.getFluid()};
    }

    @Override
    public void setFluids(FluidStack[] fluids) {
        this.tank.setFluid(fluids[0]);
    }
}

