/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.api.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketParticle;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLeafGenerator
extends TileEntityBase
implements IEnergyProvider,
IEnergySaver,
IEnergyDisplay {
    public static final int RANGE = 7;
    public static final int ENERGY_PRODUCED = 300;
    public EnergyStorage storage = new EnergyStorage(35000);
    private int nextUseCounter;
    private int oldEnergy;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered) {
                if (this.nextUseCounter >= 5) {
                    this.nextUseCounter = 0;
                    if (300 <= this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) {
                        ArrayList<Position> breakPositions = new ArrayList<Position>();
                        for (int reachX = -7; reachX < 8; ++reachX) {
                            for (int reachZ = -7; reachZ < 8; ++reachZ) {
                                for (int reachY = -7; reachY < 8; ++reachY) {
                                    Block block = this.field_145850_b.func_147439_a(this.field_145851_c + reachX, this.field_145848_d + reachY, this.field_145849_e + reachZ);
                                    if (block == null || !block.isLeaves((IBlockAccess)this.field_145850_b, this.field_145851_c + reachX, this.field_145848_d + reachY, this.field_145849_e + reachZ)) continue;
                                    breakPositions.add(new Position(this.field_145851_c + reachX, this.field_145848_d + reachY, this.field_145849_e + reachZ));
                                }
                            }
                        }
                        if (!breakPositions.isEmpty()) {
                            Collections.shuffle(breakPositions);
                            Position theCoord = (Position)breakPositions.get(0);
                            Block theBlock = this.field_145850_b.func_147439_a(theCoord.getX(), theCoord.getY(), theCoord.getZ());
                            int meta = this.field_145850_b.func_72805_g(theCoord.getX(), theCoord.getY(), theCoord.getZ());
                            this.field_145850_b.func_72926_e(2001, theCoord.getX(), theCoord.getY(), theCoord.getZ(), Block.func_149682_b((Block)theBlock) + (meta << 12));
                            this.field_145850_b.func_147468_f(theCoord.getX(), theCoord.getY(), theCoord.getZ());
                            this.storage.receiveEnergy(300, false);
                            PacketHandler.theNetwork.sendToAllAround((IMessage)new PacketParticle(this.field_145851_c, this.field_145848_d, this.field_145849_e, theCoord.getX(), theCoord.getY(), theCoord.getZ(), new float[]{0.24313726f, 0.6392157f, 0.2901961f}, 5, 1.0f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
                        }
                    }
                } else {
                    ++this.nextUseCounter;
                }
            }
            if (this.getEnergyStored(ForgeDirection.UNKNOWN) > 0) {
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UP, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.DOWN, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.NORTH, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.EAST, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.SOUTH, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.WEST, this.storage);
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.storage.readFromNBT(compound);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.extractEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }
}

