/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLavaFactoryController
extends TileEntityBase
implements IEnergyReceiver,
IEnergySaver,
IEnergyDisplay {
    public static final int NOT_MULTI = 0;
    public static final int HAS_LAVA = 1;
    public static final int HAS_AIR = 2;
    public static final int ENERGY_USE = 150000;
    private static final int[][] CASE_POSITIONS = new int[][]{{-1, 1, 0}, {1, 1, 0}, {0, 1, -1}, {0, 1, 1}};
    public EnergyStorage storage = new EnergyStorage(3000000);
    private int currentWorkTime;
    private int oldEnergy;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.storage.getEnergyStored() >= 150000 && this.isMultiblock() == 2) {
                ++this.currentWorkTime;
                if (this.currentWorkTime >= 200) {
                    this.currentWorkTime = 0;
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, Blocks.field_150353_l);
                    this.storage.extractEnergy(150000, false);
                }
            } else {
                this.currentWorkTime = 0;
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        this.storage.writeToNBT(compound);
        compound.func_74768_a("WorkTime", this.currentWorkTime);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.storage.readFromNBT(compound);
        this.currentWorkTime = compound.func_74762_e("WorkTime");
    }

    public int isMultiblock() {
        if (WorldUtil.hasBlocksInPlacesGiven(CASE_POSITIONS, InitBlocks.blockMisc, TheMiscBlocks.LAVA_FACTORY_CASE.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150353_l || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150356_k) {
                return 1;
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == null || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return from != ForgeDirection.UP ? this.storage.receiveEnergy(maxExtract, simulate) : 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return from != ForgeDirection.UP ? this.storage.getEnergyStored() : 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return from != ForgeDirection.UP ? this.storage.getMaxEnergyStored() : 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }
}

