/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.misc.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketParticle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLaserRelay
extends TileEntityBase
implements IEnergyReceiver {
    public static final int MAX_DISTANCE = 15;
    private static final float[] COLOR = new float[]{1.0f, 0.0f, 0.0f};

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.renderParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles() {
        if (Util.RANDOM.nextInt(ConfigBoolValues.LESS_LASER_RELAY_PARTICLES.isEnabled() ? 15 : 8) == 0) {
            Position thisPos = new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            LaserRelayConnectionHandler.Network network = LaserRelayConnectionHandler.getInstance().getNetworkFor(thisPos);
            if (network != null) {
                for (LaserRelayConnectionHandler.ConnectionPair aPair : network.connections) {
                    if (!aPair.contains(thisPos) || !thisPos.isEqual(aPair.firstRelay)) continue;
                    PacketParticle.renderParticlesFromAToB(aPair.firstRelay.getX(), aPair.firstRelay.getY(), aPair.firstRelay.getZ(), aPair.secondRelay.getX(), aPair.secondRelay.getY(), aPair.secondRelay.getZ(), ConfigBoolValues.LESS_LASER_RELAY_PARTICLES.isEnabled() ? 1 : Util.RANDOM.nextInt(3) + 1, 0.8f, COLOR, 1.0f);
                }
            }
        }
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        Position thisPos = new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ConcurrentSet<LaserRelayConnectionHandler.ConnectionPair> connections = LaserRelayConnectionHandler.getInstance().getConnectionsFor(thisPos);
        if (connections != null) {
            NBTTagList list = new NBTTagList();
            for (LaserRelayConnectionHandler.ConnectionPair pair : connections) {
                list.func_74742_a((NBTBase)pair.writeToNBT());
            }
            compound.func_74782_a("Connections", (NBTBase)list);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, compound);
        }
        return null;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        Position thisPos = new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (pkt != null && pkt.func_148857_g() != null) {
            LaserRelayConnectionHandler.getInstance().removeRelayFromNetwork(thisPos);
            NBTTagList list = pkt.func_148857_g().func_150295_c("Connections", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                LaserRelayConnectionHandler.ConnectionPair pair = LaserRelayConnectionHandler.ConnectionPair.readFromNBT(list.func_150305_b(i));
                LaserRelayConnectionHandler.getInstance().addConnection(pair.firstRelay, pair.secondRelay);
            }
        } else {
            LaserRelayConnectionHandler.getInstance().removeRelayFromNetwork(thisPos);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        LaserRelayConnectionHandler.getInstance().removeRelayFromNetwork(new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.transmitEnergy(WorldUtil.getCoordsFromSide(from, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0), maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int transmitEnergy(Position blockFrom, int maxTransmit, boolean simulate) {
        LaserRelayConnectionHandler.Network network;
        int transmitted = 0;
        if (maxTransmit > 0 && (network = LaserRelayConnectionHandler.getInstance().getNetworkFor(new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e))) != null) {
            transmitted = LaserRelayConnectionHandler.getInstance().transferEnergyToReceiverInNeed(this.field_145850_b, blockFrom, network, Math.min(ConfigIntValues.LASER_RELAY_MAX_TRANSFER.getValue(), maxTransmit), simulate);
        }
        return transmitted;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

