/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.api.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeatCollector
extends TileEntityBase
implements IEnergyProvider,
IEnergySaver,
IEnergyDisplay {
    public static final int ENERGY_PRODUCE = 40;
    public static final int BLOCKS_NEEDED = 4;
    public EnergyStorage storage = new EnergyStorage(30000);
    private int oldEnergy;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ArrayList<Integer> blocksAround = new ArrayList<Integer>();
            if (40 <= this.getMaxEnergyStored(ForgeDirection.UNKNOWN) - this.getEnergyStored(ForgeDirection.UNKNOWN)) {
                for (int i = 1; i <= 5; ++i) {
                    Block block;
                    Position coords = WorldUtil.getCoordsFromSide(WorldUtil.getDirectionBySidesInOrder(i), this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
                    if (coords == null || (block = this.field_145850_b.func_147439_a(coords.getX(), coords.getY(), coords.getZ())) == null || block.func_149688_o() != Material.field_151587_i || this.field_145850_b.func_72805_g(coords.getX(), coords.getY(), coords.getZ()) != 0) continue;
                    blocksAround.add(i);
                }
                if (blocksAround.size() >= 4) {
                    this.storage.receiveEnergy(40, false);
                    this.func_70296_d();
                    if (Util.RANDOM.nextInt(10000) == 0) {
                        int randomSide = (Integer)blocksAround.get(Util.RANDOM.nextInt(blocksAround.size()));
                        WorldUtil.breakBlockAtSide(WorldUtil.getDirectionBySidesInOrder(randomSide), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
            if (this.getEnergyStored(ForgeDirection.UNKNOWN) > 0) {
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UP, this.storage);
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean isForSync) {
        super.writeSyncableNBT(compound, isForSync);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean isForSync) {
        super.readSyncableNBT(compound, isForSync);
        this.storage.readFromNBT(compound);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.UP;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }
}

