/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.recipe.CrusherRecipeRegistry;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGrinder
extends TileEntityInventoryBase
implements IEnergyReceiver,
IEnergySaver {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1_1 = 1;
    public static final int SLOT_OUTPUT_1_2 = 2;
    public static final int SLOT_INPUT_2 = 3;
    public static final int SLOT_OUTPUT_2_1 = 4;
    public static final int SLOT_OUTPUT_2_2 = 5;
    public EnergyStorage storage = new EnergyStorage(60000);
    public int firstCrushTime;
    public int secondCrushTime;
    public boolean isDouble;
    private int lastEnergy;
    private int lastFirstCrush;
    private int lastSecondCrush;

    public TileEntityGrinder(int slots, String name) {
        super(slots, name);
    }

    public TileEntityGrinder() {
        super(3, "grinder");
        this.isDouble = false;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag = this.firstCrushTime > 0 || this.secondCrushTime > 0;
            boolean canCrushOnFirst = this.canCrushOn(0, 1, 2);
            boolean canCrushOnSecond = false;
            if (this.isDouble) {
                canCrushOnSecond = this.canCrushOn(3, 4, 5);
            }
            boolean shouldPlaySound = false;
            if (canCrushOnFirst) {
                if (this.storage.getEnergyStored() >= TileEntityGrinder.getEnergyUse(this.isDouble)) {
                    if (this.firstCrushTime % 30 == 0) {
                        shouldPlaySound = true;
                    }
                    ++this.firstCrushTime;
                    if (this.firstCrushTime >= this.getMaxCrushTime()) {
                        this.finishCrushing(0, 1, 2);
                        this.firstCrushTime = 0;
                    }
                }
            } else {
                this.firstCrushTime = 0;
            }
            if (this.isDouble) {
                if (canCrushOnSecond) {
                    if (this.storage.getEnergyStored() >= TileEntityGrinder.getEnergyUse(this.isDouble)) {
                        if (this.secondCrushTime % 30 == 0) {
                            shouldPlaySound = true;
                        }
                        ++this.secondCrushTime;
                        if (this.secondCrushTime >= this.getMaxCrushTime()) {
                            this.finishCrushing(3, 4, 5);
                            this.secondCrushTime = 0;
                        }
                    }
                } else {
                    this.secondCrushTime = 0;
                }
            }
            if (this.storage.getEnergyStored() >= TileEntityGrinder.getEnergyUse(this.isDouble) && (this.firstCrushTime > 0 || this.secondCrushTime > 0)) {
                this.storage.extractEnergy(TileEntityGrinder.getEnergyUse(this.isDouble), false);
            }
            if (flag != (this.firstCrushTime > 0 || this.secondCrushTime > 0)) {
                this.func_70296_d();
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (meta == 1) {
                    if (!(this.canCrushOn(0, 1, 2) || this.isDouble && this.canCrushOn(3, 4, 5))) {
                        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
                    }
                } else {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
                }
            }
            if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstCrush != this.firstCrushTime || this.lastSecondCrush != this.secondCrushTime) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastFirstCrush = this.firstCrushTime;
                this.lastSecondCrush = this.secondCrushTime;
            }
            if (shouldPlaySound) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, ModUtil.MOD_ID_LOWER + ":crusher", 0.25f, 1.0f);
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("FirstCrushTime", this.firstCrushTime);
        compound.func_74768_a("SecondCrushTime", this.secondCrushTime);
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, sync);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        this.firstCrushTime = compound.func_74762_e("FirstCrushTime");
        this.secondCrushTime = compound.func_74762_e("SecondCrushTime");
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, sync);
    }

    public boolean canCrushOn(int theInput, int theFirstOutput, int theSecondOutput) {
        List<ItemStack> outputOnes;
        if (this.slots[theInput] != null && (outputOnes = CrusherRecipeRegistry.getOutputOnes(this.slots[theInput])) != null && !outputOnes.isEmpty()) {
            ItemStack outputTwo;
            ItemStack outputOne = outputOnes.get(0);
            List<ItemStack> outputTwos = CrusherRecipeRegistry.getOutputTwos(this.slots[theInput]);
            ItemStack itemStack = outputTwo = outputTwos == null ? null : outputTwos.get(0);
            if (outputOne != null) {
                if (outputOne.func_77960_j() == Short.MAX_VALUE) {
                    outputOne.func_77964_b(0);
                }
                if (outputTwo != null && outputTwo.func_77960_j() == Short.MAX_VALUE) {
                    outputTwo.func_77964_b(0);
                }
                if ((this.slots[theFirstOutput] == null || this.slots[theFirstOutput].func_77969_a(outputOne) && this.slots[theFirstOutput].field_77994_a <= this.slots[theFirstOutput].func_77976_d() - outputOne.field_77994_a) && (outputTwo == null || this.slots[theSecondOutput] == null || this.slots[theSecondOutput].func_77969_a(outputTwo) && this.slots[theSecondOutput].field_77994_a <= this.slots[theSecondOutput].func_77976_d() - outputTwo.field_77994_a)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static int getEnergyUse(boolean isDouble) {
        return isDouble ? 60 : 40;
    }

    private int getMaxCrushTime() {
        return this.isDouble ? 150 : 100;
    }

    public void finishCrushing(int theInput, int theFirstOutput, int theSecondOutput) {
        ItemStack outputTwo;
        List<ItemStack> outputTwos;
        ItemStack outputOne;
        List<ItemStack> outputOnes = CrusherRecipeRegistry.getOutputOnes(this.slots[theInput]);
        if (outputOnes != null && (outputOne = outputOnes.get(0)) != null) {
            if (outputOne.func_77960_j() == Short.MAX_VALUE) {
                outputOne.func_77964_b(0);
            }
            if (this.slots[theFirstOutput] == null) {
                this.slots[theFirstOutput] = outputOne.func_77946_l();
            } else if (this.slots[theFirstOutput].func_77973_b() == outputOne.func_77973_b()) {
                this.slots[theFirstOutput].field_77994_a += outputOne.field_77994_a;
            }
        }
        if ((outputTwos = CrusherRecipeRegistry.getOutputTwos(this.slots[theInput])) != null && (outputTwo = outputTwos.get(0)) != null) {
            int rand;
            if (outputTwo.func_77960_j() == Short.MAX_VALUE) {
                outputTwo.func_77964_b(0);
            }
            if ((rand = Util.RANDOM.nextInt(100) + 1) <= CrusherRecipeRegistry.getOutputTwoChance(this.slots[theInput])) {
                if (this.slots[theSecondOutput] == null) {
                    this.slots[theSecondOutput] = outputTwo.func_77946_l();
                } else if (this.slots[theSecondOutput].func_77973_b() == outputTwo.func_77973_b()) {
                    this.slots[theSecondOutput].field_77994_a += outputTwo.field_77994_a;
                }
            }
        }
        --this.slots[theInput].field_77994_a;
        if (this.slots[theInput].field_77994_a <= 0) {
            this.slots[theInput] = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getFirstTimeToScale(int i) {
        return this.firstCrushTime * i / this.getMaxCrushTime();
    }

    @SideOnly(value=Side.CLIENT)
    public int getSecondTimeToScale(int i) {
        return this.secondCrushTime * i / this.getMaxCrushTime();
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return (i == 0 || i == 3) && CrusherRecipeRegistry.getRecipeFromInput(stack) != null;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1 || slot == 2 || slot == 4 || slot == 5;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    public static class TileEntityGrinderDouble
    extends TileEntityGrinder {
        public TileEntityGrinderDouble() {
            super(6, "grinderDouble");
            this.isDouble = true;
        }
    }
}

