/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.IRedstoneToggle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFireworkBox
extends TileEntityBase
implements IEnergyReceiver,
IRedstoneToggle,
IEnergyDisplay,
IEnergySaver {
    public static final int USE_PER_SHOT = 300;
    public EnergyStorage storage = new EnergyStorage(20000);
    private int timeUntilNextFirework;
    private boolean activateOnceWithSignal;
    private int oldEnergy;

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.activateOnceWithSignal) {
                if (this.timeUntilNextFirework > 0) {
                    --this.timeUntilNextFirework;
                    if (this.timeUntilNextFirework <= 0) {
                        this.doWork();
                    }
                } else {
                    this.timeUntilNextFirework = 100;
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 300) {
            int range = 4;
            int amount = Util.RANDOM.nextInt(5) + 1;
            for (int i = 0; i < amount; ++i) {
                ItemStack firework = this.makeFirework();
                double x = (double)this.field_145851_c + MathHelper.func_82716_a((Random)Util.RANDOM, (double)0.0, (double)(range * 2)) - (double)range;
                double z = (double)this.field_145849_e + MathHelper.func_82716_a((Random)Util.RANDOM, (double)0.0, (double)(range * 2)) - (double)range;
                EntityFireworkRocket rocket = new EntityFireworkRocket(this.field_145850_b, x, (double)this.field_145848_d + 0.5, z, firework);
                this.field_145850_b.func_72838_d((Entity)rocket);
            }
            this.storage.extractEnergy(300, false);
        }
    }

    private ItemStack makeFirework() {
        NBTTagList list = new NBTTagList();
        int chargesAmount = Util.RANDOM.nextInt(2) + 1;
        for (int i = 0; i < chargesAmount; ++i) {
            list.func_74742_a((NBTBase)this.makeFireworkCharge());
        }
        NBTTagCompound compound1 = new NBTTagCompound();
        compound1.func_74782_a("Explosions", (NBTBase)list);
        compound1.func_74774_a("Flight", (byte)(Util.RANDOM.nextInt(3) + 1));
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Fireworks", (NBTBase)compound1);
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.func_77982_d(compound);
        return firework;
    }

    private NBTTagCompound makeFireworkCharge() {
        NBTTagCompound compound = new NBTTagCompound();
        if (Util.RANDOM.nextFloat() >= 0.65f) {
            if (Util.RANDOM.nextFloat() >= 0.5f) {
                compound.func_74757_a("Flicker", true);
            } else {
                compound.func_74757_a("Trail", true);
            }
        }
        int[] colors = new int[MathHelper.func_76136_a((Random)Util.RANDOM, (int)1, (int)6)];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[Util.RANDOM.nextInt(ItemDye.field_150922_c.length)];
        }
        compound.func_74783_a("Colors", colors);
        compound.func_74774_a("Type", (byte)Util.RANDOM.nextInt(5));
        return compound;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.storage.readFromNBT(compound);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public void toggle(boolean to) {
        this.activateOnceWithSignal = to;
    }

    @Override
    public boolean isPulseMode() {
        return this.activateOnceWithSignal;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }
}

