/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.IFluidSaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityCanolaPress
extends TileEntityInventoryBase
implements IEnergyReceiver,
IFluidHandler,
IEnergySaver,
IFluidSaver {
    public static final int PRODUCE = 120;
    public static final int ENERGY_USE = 35;
    private static final int TIME = 30;
    public EnergyStorage storage = new EnergyStorage(40000);
    public FluidTank tank = new FluidTank(2000);
    public int currentProcessTime;
    private int lastEnergyStored;
    private int lastTankAmount;
    private int lastProcessTime;

    public TileEntityCanolaPress() {
        super(3, "canolaPress");
    }

    @SideOnly(value=Side.CLIENT)
    public int getTankScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getProcessScaled(int i) {
        return this.currentProcessTime * i / 30;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isCanola(0) && 120 <= this.tank.getCapacity() - this.tank.getFluidAmount()) {
                if (this.storage.getEnergyStored() >= 35) {
                    ++this.currentProcessTime;
                    this.storage.extractEnergy(35, false);
                    if (this.currentProcessTime >= 30) {
                        this.currentProcessTime = 0;
                        --this.slots[0].field_77994_a;
                        if (this.slots[0].field_77994_a == 0) {
                            this.slots[0] = null;
                        }
                        this.tank.fill(new FluidStack(InitBlocks.fluidCanolaOil, 120), true);
                        this.func_70296_d();
                    }
                }
            } else {
                this.currentProcessTime = 0;
            }
            WorldUtil.fillBucket(this.tank, this.slots, 1, 2);
            if (this.tank.getFluidAmount() > 0) {
                WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.DOWN, this.tank);
                if (!this.isRedstonePowered) {
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.NORTH, this.tank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.EAST, this.tank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.SOUTH, this.tank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.WEST, this.tank);
                }
            }
            if ((this.storage.getEnergyStored() != this.lastEnergyStored || this.tank.getFluidAmount() != this.lastTankAmount | this.currentProcessTime != this.lastProcessTime) && this.sendUpdateWithInterval()) {
                this.lastEnergyStored = this.storage.getEnergyStored();
                this.lastProcessTime = this.currentProcessTime;
                this.lastTankAmount = this.tank.getFluidAmount();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("ProcessTime", this.currentProcessTime);
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        super.writeSyncableNBT(compound, sync);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        this.currentProcessTime = compound.func_74762_e("ProcessTime");
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        super.readSyncableNBT(compound, sync);
    }

    public boolean isCanola(int slot) {
        return this.slots[slot] != null && this.slots[slot].func_77973_b() == InitItems.itemMisc && this.slots[slot].func_77960_j() == TheMiscItems.CANOLA.ordinal();
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0 && stack.func_77973_b() == InitItems.itemMisc && stack.func_77960_j() == TheMiscItems.CANOLA.ordinal() || i == 1 && stack.func_77973_b() == Items.field_151133_ar;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2 && FluidContainerRegistry.containsFluid((ItemStack)this.slots[0], (FluidStack)new FluidStack(InitBlocks.fluidCanolaOil, 1000));
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.getFluid() == InitBlocks.fluidCanolaOil) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    public FluidStack[] getFluids() {
        return new FluidStack[]{this.tank.getFluid()};
    }

    @Override
    public void setFluids(FluidStack[] fluids) {
        this.tank.setFluid(fluids[0]);
    }
}

