/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.ellpeck.actuallyadditions.mod.network.gui.IStringReactor;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketGuiString
implements IMessage {
    private int tileX;
    private int tileY;
    private int tileZ;
    private int worldID;
    private String text;
    private int textID;
    private int playerID;

    public PacketGuiString() {
    }

    public PacketGuiString(int x, int y, int z, World world, String text, int textID, EntityPlayer player) {
        this.tileX = x;
        this.tileY = y;
        this.tileZ = z;
        this.worldID = world.field_73011_w.field_76574_g;
        this.text = text;
        this.textID = textID;
        this.playerID = player.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.tileX = buf.readInt();
        this.tileY = buf.readInt();
        this.tileZ = buf.readInt();
        this.worldID = buf.readInt();
        this.text = "";
        int textLength = buf.readInt();
        for (int i = 0; i < textLength; ++i) {
            this.text = this.text + buf.readChar();
        }
        this.textID = buf.readInt();
        this.playerID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tileX);
        buf.writeInt(this.tileY);
        buf.writeInt(this.tileZ);
        buf.writeInt(this.worldID);
        buf.writeInt(this.text.length());
        for (int i = 0; i < this.text.length(); ++i) {
            buf.writeChar((int)this.text.charAt(i));
        }
        buf.writeInt(this.textID);
        buf.writeInt(this.playerID);
    }

    public static class Handler
    implements IMessageHandler<PacketGuiString, IMessage> {
        public IMessage onMessage(PacketGuiString message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.worldID);
            TileEntity tile = world.func_147438_o(message.tileX, message.tileY, message.tileZ);
            if (tile instanceof IStringReactor) {
                IStringReactor reactor = (IStringReactor)tile;
                reactor.onTextReceived(message.text, message.textID, (EntityPlayer)world.func_73045_a(message.playerID));
            }
            return null;
        }
    }
}

