/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.INEIRecipeHandler;
import de.ellpeck.actuallyadditions.api.recipe.LensNoneRecipe;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.lens.LensColor;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIReconstructorRecipe
extends TemplateRecipeHandler
implements INEIRecipeHandler {
    public static final String NAME = "actuallyadditions.reconstructor";

    public NEIReconstructorRecipe() {
        RecipeInfo.setGuiOffset(this.getGuiClass(), (int)0, (int)0);
    }

    @Override
    public BookletPage getPageForInfo(int page) {
        return BookletUtils.getFirstPageForStack(new ItemStack(InitBlocks.blockAtomicReconstructor));
    }

    public String getRecipeName() {
        return StringUtil.localize("container.nei.actuallyadditions.reconstructor.name");
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(63, 18, 22, 16), NAME, new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(NAME) && this.getClass() == NEIReconstructorRecipe.class) {
            List<LensNoneRecipe> recipes = ActuallyAdditionsAPI.reconstructorLensNoneRecipes;
            for (LensNoneRecipe recipe : recipes) {
                this.arecipes.add(new CachedReconstructorRecipe(recipe, false));
            }
            for (Object o : LensColor.CONVERTABLE_BLOCKS) {
                ItemStack stack = o instanceof Block ? new ItemStack((Block)o) : new ItemStack((Item)o);
                for (int i = 0; i < 16; ++i) {
                    ItemStack stackCopy = stack.func_77946_l();
                    stackCopy.func_77964_b(i >= 15 ? 0 : i + 1);
                    stack.func_77964_b(i);
                    this.arecipes.add(new CachedReconstructorRecipe(new LensNoneRecipe(stack, stackCopy, 200), true));
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<LensNoneRecipe> recipes = ActuallyAdditionsAPI.reconstructorLensNoneRecipes;
        for (LensNoneRecipe recipe : recipes) {
            if (!ItemUtil.contains(recipe.getOutputs(), result, true)) continue;
            this.arecipes.add(new CachedReconstructorRecipe(recipe, false));
        }
        if (result.func_77973_b() != null && (Util.arrayContains(LensColor.CONVERTABLE_BLOCKS, result.func_77973_b()) >= 0 || Util.arrayContains(LensColor.CONVERTABLE_BLOCKS, Block.func_149634_a((Item)result.func_77973_b())) >= 0)) {
            int meta = result.func_77960_j();
            ItemStack input = result.func_77946_l();
            input.func_77964_b(meta <= 0 ? 15 : meta - 1);
            this.arecipes.add(new CachedReconstructorRecipe(new LensNoneRecipe(input, result, 200), true));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<LensNoneRecipe> recipes = ActuallyAdditionsAPI.reconstructorLensNoneRecipes;
        for (LensNoneRecipe recipe : recipes) {
            if (!ItemUtil.contains(recipe.getInputs(), ingredient, true)) continue;
            CachedReconstructorRecipe theRecipe = new CachedReconstructorRecipe(recipe, false);
            theRecipe.setIngredientPermutation(Collections.singletonList(theRecipe.input), ingredient);
            this.arecipes.add(theRecipe);
        }
        if (ingredient.func_77973_b() != null && (Util.arrayContains(LensColor.CONVERTABLE_BLOCKS, ingredient.func_77973_b()) >= 0 || Util.arrayContains(LensColor.CONVERTABLE_BLOCKS, Block.func_149634_a((Item)ingredient.func_77973_b())) >= 0)) {
            int meta = ingredient.func_77960_j();
            ItemStack output = ingredient.func_77946_l();
            output.func_77964_b(meta >= 15 ? 0 : meta + 1);
            this.arecipes.add(new CachedReconstructorRecipe(new LensNoneRecipe(ingredient, output, 200), true));
        }
    }

    public String getGuiTexture() {
        return ModUtil.MOD_ID_LOWER + ":textures/gui/guiNEIAtomicReconstructor.png";
    }

    public String getOverlayIdentifier() {
        return NAME;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)32, (int)0, (int)0, (int)0, (int)96, (int)60);
    }

    public void drawForeground(int recipe) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            AssetUtil.renderStackToGui(new ItemStack(InitBlocks.blockAtomicReconstructor), 66, 19, 1.0f);
        }
        if (((CachedReconstructorRecipe)((Object)this.arecipes.get((int)recipe))).showColorLens) {
            String text = InitItems.itemColorLens.func_77653_i(new ItemStack(InitItems.itemColorLens));
            GuiDraw.drawString((String)text, (int)0, (int)44, (int)0x404040, (boolean)false);
        }
    }

    public int recipiesPerPage() {
        return 2;
    }

    public class CachedReconstructorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack result;
        public PositionedStack input;
        public boolean showColorLens;

        public CachedReconstructorRecipe(LensNoneRecipe recipe, boolean showColorLens) {
            super((TemplateRecipeHandler)NEIReconstructorRecipe.this);
            this.result = new PositionedStack(recipe.getOutputs(), 99, 19);
            this.input = new PositionedStack(recipe.getInputs(), 37, 19);
            this.showColorLens = showColorLens;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIReconstructorRecipe.this.cycleticks / 48, Collections.singletonList(this.input));
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            list.addAll(this.getCycledIngredients(NEIReconstructorRecipe.this.cycleticks / 48, Collections.singletonList(this.result)));
            return list;
        }
    }
}

