/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.INEIRecipeHandler;
import de.ellpeck.actuallyadditions.api.recipe.BallOfFurReturn;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIHairyBallRecipe
extends TemplateRecipeHandler
implements INEIRecipeHandler {
    public static final String NAME = "actuallyadditions.ballOfHair";

    public NEIHairyBallRecipe() {
        RecipeInfo.setGuiOffset(this.getGuiClass(), (int)0, (int)0);
    }

    @Override
    public BookletPage getPageForInfo(int page) {
        return BookletUtils.getFirstPageForStack(new ItemStack(InitItems.itemHairyBall));
    }

    public String getRecipeName() {
        return StringUtil.localize("container.nei.actuallyadditions.ballOfHair.name");
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(63, 18, 22, 16), NAME, new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(NAME) && this.getClass() == NEIHairyBallRecipe.class) {
            List<BallOfFurReturn> recipes = ActuallyAdditionsAPI.ballOfFurReturnItems;
            for (BallOfFurReturn recipe : recipes) {
                this.arecipes.add(new CachedBallRecipe(new ItemStack(InitItems.itemHairyBall), recipe.returnItem, recipe.field_76292_a));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<BallOfFurReturn> recipes = ActuallyAdditionsAPI.ballOfFurReturnItems;
        for (BallOfFurReturn recipe : recipes) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.returnItem, (ItemStack)result)) continue;
            this.arecipes.add(new CachedBallRecipe(new ItemStack(InitItems.itemHairyBall), recipe.returnItem, recipe.field_76292_a));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<BallOfFurReturn> recipes = ActuallyAdditionsAPI.ballOfFurReturnItems;
        for (BallOfFurReturn recipe : recipes) {
            ItemStack stack = new ItemStack(InitItems.itemHairyBall);
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
            CachedBallRecipe theRecipe = new CachedBallRecipe(stack, recipe.returnItem, recipe.field_76292_a);
            theRecipe.setIngredientPermutation(Collections.singletonList(theRecipe.input), ingredient);
            this.arecipes.add(theRecipe);
        }
    }

    public String getGuiTexture() {
        return ModUtil.MOD_ID_LOWER + ":textures/gui/guiNEISimple.png";
    }

    public String getOverlayIdentifier() {
        return NAME;
    }

    public void drawExtras(int rec) {
        CachedBallRecipe recipe = (CachedBallRecipe)((Object)this.arecipes.get(rec));
        if (recipe.result != null) {
            int secondChance = recipe.chance;
            String secondString = secondChance + "%";
            GuiDraw.drawString((String)secondString, (int)97, (int)45, (int)0x404040, (boolean)false);
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)32, (int)0, (int)0, (int)0, (int)96, (int)60);
    }

    public int recipiesPerPage() {
        return 2;
    }

    public class CachedBallRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack result;
        public PositionedStack input;
        public int chance;

        public CachedBallRecipe(ItemStack input, ItemStack result, int chance) {
            super((TemplateRecipeHandler)NEIHairyBallRecipe.this);
            this.result = new PositionedStack((Object)result, 99, 19);
            this.chance = chance;
            this.input = new PositionedStack((Object)input, 37, 19);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }
    }
}

