/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.INEIRecipeHandler;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiGrinder;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEICrusherRecipe
extends TemplateRecipeHandler
implements INEIRecipeHandler {
    public NEICrusherRecipe() {
        RecipeInfo.setGuiOffset(this.getGuiClass(), (int)0, (int)0);
    }

    @Override
    public BookletPage getPageForInfo(int page) {
        return BookletUtils.getFirstPageForStack(new ItemStack(InitBlocks.blockGrinder));
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(80, 40, 24, 22), this.getBaseName(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getBaseName()) && (this.getClass() == NEICrusherRecipe.class || this.getClass() == Double.class)) {
            for (CrusherRecipe recipe : ActuallyAdditionsAPI.crusherRecipes) {
                this.arecipes.add(new CachedCrush(recipe.getRecipeInputs(), recipe.getRecipeOutputOnes(), recipe.getRecipeOutputTwos(), recipe.outputTwoChance, this));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (CrusherRecipe recipe : ActuallyAdditionsAPI.crusherRecipes) {
            if (!ItemUtil.contains(recipe.getRecipeOutputOnes(), result, true) && !ItemUtil.contains(recipe.getRecipeOutputTwos(), result, true)) continue;
            this.arecipes.add(new CachedCrush(recipe.getRecipeInputs(), recipe.getRecipeOutputOnes(), recipe.getRecipeOutputTwos(), recipe.outputTwoChance, this));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (CrusherRecipe recipe : ActuallyAdditionsAPI.crusherRecipes) {
            if (!ItemUtil.contains(recipe.getRecipeInputs(), ingredient, true)) continue;
            CachedCrush theRecipe = new CachedCrush(recipe.getRecipeInputs(), recipe.getRecipeOutputOnes(), recipe.getRecipeOutputTwos(), recipe.outputTwoChance, this);
            theRecipe.setIngredientPermutation(Collections.singletonList(theRecipe.ingredient), ingredient);
            this.arecipes.add(theRecipe);
        }
    }

    public String getGuiTexture() {
        return ModUtil.MOD_ID_LOWER + ":textures/gui/guiGrinder.png";
    }

    public String getOverlayIdentifier() {
        return this.getBaseName();
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(80, 40, 176, 0, 24, 23, 48, 1);
        this.drawChanceString(118, 73, recipe);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiGrinder.class;
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)60, (int)13, (int)60, (int)13, (int)56, (int)79);
    }

    public int recipiesPerPage() {
        return 1;
    }

    protected void drawChanceString(int x, int y, int recipe) {
        CachedCrush crush = (CachedCrush)((Object)this.arecipes.get(recipe));
        if (crush.resultTwo != null) {
            int secondChance = crush.secondChance;
            String secondString = secondChance + "%";
            GuiDraw.drawString((String)secondString, (int)x, (int)y, (int)0x404040, (boolean)false);
        }
    }

    protected String getBaseName() {
        return "actuallyadditions." + (this instanceof Double ? "crushingDouble" : "crushing");
    }

    public String getRecipeName() {
        return StringUtil.localize("container.nei." + this.getBaseName() + ".name");
    }

    public class CachedCrush
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack ingredient;
        public PositionedStack resultOne;
        public PositionedStack resultTwo;
        public int secondChance;

        public CachedCrush(List<ItemStack> in, List<ItemStack> outOne, List<ItemStack> outTwo, int secondChance, NEICrusherRecipe handler) {
            super((TemplateRecipeHandler)NEICrusherRecipe.this);
            boolean isDouble = handler instanceof Double;
            this.ingredient = new PositionedStack(in, isDouble ? 51 : 80, 21);
            this.resultOne = new PositionedStack(outOne, isDouble ? 38 : 66, 69);
            if (outTwo != null && !outTwo.isEmpty()) {
                this.resultTwo = new PositionedStack(outTwo, isDouble ? 63 : 94, 69);
            }
            this.secondChance = secondChance;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEICrusherRecipe.this.cycleticks / 48, Collections.singletonList(this.ingredient));
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            list.addAll(this.getCycledIngredients(NEICrusherRecipe.this.cycleticks / 48, Collections.singletonList(this.resultOne)));
            if (this.resultTwo != null) {
                list.addAll(this.getCycledIngredients(NEICrusherRecipe.this.cycleticks / 48, Collections.singletonList(this.resultTwo)));
            }
            return list;
        }
    }

    public static class Double
    extends NEICrusherRecipe {
        @Override
        public BookletPage getPageForInfo(int page) {
            return BookletUtils.getFirstPageForStack(new ItemStack(InitBlocks.blockGrinderDouble));
        }

        @Override
        public void loadTransferRects() {
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(51, 40, 24, 22), this.getBaseName(), new Object[0]));
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(101, 40, 24, 22), this.getBaseName(), new Object[0]));
        }

        @Override
        public String getGuiTexture() {
            return ModUtil.MOD_ID_LOWER + ":textures/gui/guiGrinderDouble.png";
        }

        @Override
        public void drawExtras(int recipe) {
            this.drawProgressBar(51, 40, 176, 0, 24, 23, 48, 1);
            this.drawChanceString(66, 93, recipe);
        }

        @Override
        public Class<? extends GuiContainer> getGuiClass() {
            return GuiGrinder.GuiGrinderDouble.class;
        }

        @Override
        public void drawBackground(int recipeIndex) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)this.getGuiTexture());
            GuiDraw.drawTexturedModalRect((int)33, (int)20, (int)33, (int)20, (int)110, (int)70);
        }
    }
}

