/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.INEIRecipeHandler;
import de.ellpeck.actuallyadditions.api.recipe.coffee.CoffeeBrewing;
import de.ellpeck.actuallyadditions.api.recipe.coffee.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEICoffeeMachineRecipe
extends TemplateRecipeHandler
implements INEIRecipeHandler {
    public static final String NAME = "actuallyadditions.coffee";

    public NEICoffeeMachineRecipe() {
        RecipeInfo.setGuiOffset(this.getGuiClass(), (int)35, (int)3);
    }

    @Override
    public BookletPage getPageForInfo(int page) {
        return BookletUtils.getFirstPageForStack(new ItemStack(InitBlocks.blockCoffeeMachine));
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(20, 39, 20, 16), NAME, new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(64, 42, 23, 10), NAME, new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(NAME) && this.getClass() == NEICoffeeMachineRecipe.class) {
            List<CoffeeIngredient> ingredients = ActuallyAdditionsAPI.coffeeMachineIngredients;
            for (CoffeeIngredient ingredient : ingredients) {
                this.arecipes.add(new CachedCoffee(ingredient));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<CoffeeIngredient> ingredients = ActuallyAdditionsAPI.coffeeMachineIngredients;
        for (CoffeeIngredient ingredient : ingredients) {
            if (!(result.func_77973_b() instanceof ItemCoffee)) continue;
            this.arecipes.add(new CachedCoffee(ingredient));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<CoffeeIngredient> ingredients = ActuallyAdditionsAPI.coffeeMachineIngredients;
        for (CoffeeIngredient ingr : ingredients) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack(InitItems.itemMisc, 1, TheMiscItems.CUP.ordinal()), (ItemStack)ingredient) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack(InitItems.itemCoffeeBean), (ItemStack)ingredient) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingr.ingredient.func_77946_l(), (ItemStack)ingredient)) continue;
            CachedCoffee theRecipe = new CachedCoffee(ingr);
            theRecipe.setIngredientPermutation(Collections.singletonList(theRecipe.ingredientStack), ingredient);
            this.arecipes.add(theRecipe);
        }
    }

    public String getGuiTexture() {
        return ModUtil.MOD_ID_LOWER + ":textures/gui/guiNEICoffeeMachine.png";
    }

    public String getOverlayIdentifier() {
        return NAME;
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(20, 39, 126, 0, 21, 16, 48, 0);
        this.drawProgressBar(63, 42, 125, 16, 24, 12, 48, 2);
        CachedCoffee cache = (CachedCoffee)((Object)this.arecipes.get(recipe));
        if (cache.extraText != null) {
            GuiDraw.drawString((String)(StringUtil.localize("container.nei." + ModUtil.MOD_ID_LOWER + ".coffee.special") + ":"), (int)2, (int)4, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)cache.extraText, (int)2, (int)16, (int)0x404040, (boolean)false);
        }
        GuiDraw.drawString((String)StringUtil.localize("container.nei." + ModUtil.MOD_ID_LOWER + ".coffee.shift"), (int)1, (int)75, (int)0x404040, (boolean)false);
        if (cache.maxAmp > 0) {
            GuiDraw.drawString((String)(StringUtil.localize("container.nei." + ModUtil.MOD_ID_LOWER + ".coffee.maxAmount") + ": " + cache.maxAmp), (int)2, (int)28, (int)0x404040, (boolean)false);
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCoffeeMachine.class;
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)126, (int)88);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return StringUtil.localize("container.nei.actuallyadditions.coffee.name");
    }

    public class CachedCoffee
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack cup;
        public PositionedStack coffeeBeans;
        public PositionedStack result;
        public PositionedStack ingredientStack;
        public String extraText;
        public int maxAmp;

        public CachedCoffee(CoffeeIngredient ingredient) {
            super((TemplateRecipeHandler)NEICoffeeMachineRecipe.this);
            this.cup = new PositionedStack((Object)new ItemStack(InitItems.itemMisc, 1, TheMiscItems.CUP.ordinal()), 45, 39);
            this.coffeeBeans = new PositionedStack((Object)new ItemStack(InitItems.itemCoffeeBean, 15), 2, 39);
            this.ingredientStack = new PositionedStack((Object)ingredient.ingredient.func_77946_l(), 90, 21);
            this.setupResult(ingredient);
            this.extraText = ingredient.getExtraText();
            this.maxAmp = ingredient.maxAmplifier;
        }

        public void setupResult(CoffeeIngredient ingredient) {
            ItemStack result = new ItemStack(InitItems.itemCoffee);
            CoffeeBrewing.addEffectToStack(result, ingredient);
            this.result = new PositionedStack((Object)result.func_77946_l(), 45, 70);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            list.add(this.ingredientStack);
            list.add(this.cup);
            list.add(this.coffeeBeans);
            return list;
        }
    }
}

