/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc;

import de.ellpeck.actuallyadditions.mod.misc.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.playerdata.PersistentServerData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class WorldData
extends WorldSavedData {
    public static final String DATA_TAG = "ActuallyAdditionsWorldData";
    public static WorldData instance;

    public WorldData(String tag) {
        super(tag);
    }

    public static void makeDirty() {
        if (instance != null) {
            instance.func_76185_a();
        }
    }

    public static void init(MinecraftServer server) {
        if (server != null) {
            World world = server.func_130014_f_();
            if (!world.field_72995_K) {
                WorldData.clearOldData();
                ModUtil.LOGGER.info("Loading WorldData!");
                WorldData savedData = (WorldData)world.func_72943_a(WorldData.class, DATA_TAG);
                if (savedData == null) {
                    ModUtil.LOGGER.info("No WorldData found, creating...");
                    savedData = new WorldData(DATA_TAG);
                    world.func_72823_a(DATA_TAG, (WorldSavedData)savedData);
                } else {
                    ModUtil.LOGGER.info("WorldData sucessfully received!");
                }
                instance = savedData;
            }
        }
    }

    public static void clearOldData() {
        if (!LaserRelayConnectionHandler.getInstance().networks.isEmpty()) {
            ModUtil.LOGGER.info("Clearing leftover Laser Relay Connection Data from other worlds!");
            LaserRelayConnectionHandler.getInstance().networks.clear();
        }
        if (!PersistentServerData.playerSaveData.isEmpty()) {
            ModUtil.LOGGER.info("Clearing leftover Persistent Server Data from other worlds!");
            PersistentServerData.playerSaveData.clear();
        }
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList networkList = compound.func_150295_c("Networks", 10);
        for (int i = 0; i < networkList.func_74745_c(); ++i) {
            LaserRelayConnectionHandler.Network network = LaserRelayConnectionHandler.getInstance().readNetworkFromNBT(networkList.func_150305_b(i));
            LaserRelayConnectionHandler.getInstance().networks.add((Object)network);
        }
        NBTTagList playerList = compound.func_150295_c("PlayerData", 10);
        for (int i = 0; i < playerList.func_74745_c(); ++i) {
            PersistentServerData.PlayerSave aSave = PersistentServerData.PlayerSave.fromNBT(playerList.func_150305_b(i));
            PersistentServerData.playerSaveData.add(aSave);
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        NBTTagList networkList = new NBTTagList();
        for (LaserRelayConnectionHandler.Network network : LaserRelayConnectionHandler.getInstance().networks) {
            networkList.func_74742_a((NBTBase)LaserRelayConnectionHandler.getInstance().writeNetworkToNBT(network));
        }
        compound.func_74782_a("Networks", (NBTBase)networkList);
        NBTTagList playerList = new NBTTagList();
        for (int i = 0; i < PersistentServerData.playerSaveData.size(); ++i) {
            PersistentServerData.PlayerSave theSave = PersistentServerData.playerSaveData.get(i);
            playerList.func_74742_a((NBTBase)theSave.toNBT());
        }
        compound.func_74782_a("PlayerData", (NBTBase)playerList);
    }
}

