/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc;

import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.misc.WorldData;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LaserRelayConnectionHandler {
    private static LaserRelayConnectionHandler instance;
    public ConcurrentSet<Network> networks = new ConcurrentSet();

    public static LaserRelayConnectionHandler getInstance() {
        return instance;
    }

    public static void setInstance(LaserRelayConnectionHandler handler) {
        instance = handler;
    }

    public NBTTagCompound writeNetworkToNBT(Network network) {
        NBTTagList list = new NBTTagList();
        for (ConnectionPair pair : network.connections) {
            list.func_74742_a((NBTBase)pair.writeToNBT());
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Network", (NBTBase)list);
        return compound;
    }

    public Network readNetworkFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Network", 10);
        Network network = new Network();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            network.connections.add((Object)ConnectionPair.readFromNBT(list.func_150305_b(i)));
        }
        return network;
    }

    public ConcurrentSet<ConnectionPair> getConnectionsFor(Position relay) {
        ConcurrentSet allPairs = new ConcurrentSet();
        for (Network aNetwork : this.networks) {
            for (ConnectionPair pair : aNetwork.connections) {
                if (!pair.contains(relay)) continue;
                allPairs.add((Object)pair);
            }
        }
        return allPairs;
    }

    public void removeRelayFromNetwork(Position relay) {
        Network network = this.getNetworkFor(relay);
        if (network != null) {
            this.networks.remove((Object)network);
            for (ConnectionPair pair : network.connections) {
                if (pair.contains(relay)) continue;
                this.addConnection(pair.firstRelay, pair.secondRelay);
            }
        }
        WorldData.makeDirty();
    }

    public Network getNetworkFor(Position relay) {
        for (Network aNetwork : this.networks) {
            for (ConnectionPair pair : aNetwork.connections) {
                if (!pair.contains(relay)) continue;
                return aNetwork;
            }
        }
        return null;
    }

    public boolean addConnection(Position firstRelay, Position secondRelay) {
        int distance = (int)firstRelay.toVec().func_72438_d(secondRelay.toVec());
        if (distance > 15 || firstRelay.isEqual(secondRelay)) {
            return false;
        }
        Network firstNetwork = this.getNetworkFor(firstRelay);
        Network secondNetwork = this.getNetworkFor(secondRelay);
        if (firstNetwork == null && secondNetwork == null) {
            firstNetwork = new Network();
            this.networks.add((Object)firstNetwork);
            firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay));
        } else {
            if (firstNetwork == secondNetwork) {
                return false;
            }
            if (firstNetwork != null && secondNetwork != null) {
                this.mergeNetworks(firstNetwork, secondNetwork);
                firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay));
            } else if (firstNetwork != null) {
                firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay));
            } else if (secondNetwork != null) {
                secondNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay));
            }
        }
        WorldData.makeDirty();
        return true;
    }

    public void mergeNetworks(Network firstNetwork, Network secondNetwork) {
        for (ConnectionPair secondPair : secondNetwork.connections) {
            firstNetwork.connections.add((Object)secondPair);
        }
        this.networks.remove((Object)secondNetwork);
        WorldData.makeDirty();
    }

    public int transferEnergyToReceiverInNeed(World world, Position energyGottenFrom, Network network, int maxTransfer, boolean simulate) {
        int transmitted = 0;
        for (ConnectionPair pair : network.connections) {
            Position[] relays;
            for (Position relay : relays = new Position[]{pair.firstRelay, pair.secondRelay}) {
                if (relay == null) continue;
                for (int i = 0; i <= 5; ++i) {
                    IEnergyReceiver receiver;
                    TileEntity tile;
                    ForgeDirection side = ForgeDirection.getOrientation((int)i);
                    Position pos = WorldUtil.getCoordsFromSide(side, relay.getX(), relay.getY(), relay.getZ(), 0);
                    if (pos.isEqual(energyGottenFrom) || !((tile = pos.getTileEntity(world)) instanceof IEnergyReceiver) || tile instanceof TileEntityLaserRelay || !(receiver = (IEnergyReceiver)tile).canConnectEnergy(side.getOpposite())) continue;
                    int theoreticalReceived = ((IEnergyReceiver)tile).receiveEnergy(side.getOpposite(), maxTransfer - transmitted, true);
                    int deduct = (int)((double)theoreticalReceived * ((double)ConfigIntValues.LASER_RELAY_LOSS.getValue() / 100.0));
                    transmitted += ((IEnergyReceiver)tile).receiveEnergy(side.getOpposite(), theoreticalReceived - deduct, simulate);
                    if ((transmitted += deduct) < maxTransfer) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    public static class Network {
        public ConcurrentSet<ConnectionPair> connections = new ConcurrentSet();

        public String toString() {
            return this.connections.toString();
        }
    }

    public static class ConnectionPair {
        public Position firstRelay;
        public Position secondRelay;

        public ConnectionPair(Position firstRelay, Position secondRelay) {
            this.firstRelay = firstRelay;
            this.secondRelay = secondRelay;
        }

        public static ConnectionPair readFromNBT(NBTTagCompound compound) {
            if (compound != null) {
                Position[] pos = new Position[2];
                for (int i = 0; i < pos.length; ++i) {
                    int anX = compound.func_74762_e("x" + i);
                    int aY = compound.func_74762_e("y" + i);
                    int aZ = compound.func_74762_e("z" + i);
                    pos[i] = new Position(anX, aY, aZ);
                }
                return new ConnectionPair(pos[0], pos[1]);
            }
            return null;
        }

        public boolean contains(Position relay) {
            return this.firstRelay != null && this.firstRelay.isEqual(relay) || this.secondRelay != null && this.secondRelay.isEqual(relay);
        }

        public String toString() {
            return (this.firstRelay == null ? "-" : this.firstRelay.toString()) + " | " + (this.secondRelay == null ? "-" : this.secondRelay.toString());
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            for (int i = 0; i < 2; ++i) {
                Position relay = i == 0 ? this.firstRelay : this.secondRelay;
                compound.func_74768_a("x" + i, relay.getX());
                compound.func_74768_a("y" + i, relay.getY());
                compound.func_74768_a("z" + i, relay.getZ());
            }
            return compound;
        }
    }
}

