/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import cofh.api.energy.IEnergyContainerItem;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheColoredLampColors;
import de.ellpeck.actuallyadditions.mod.config.ConfigValues;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.ItemDrillUpgrade;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemDrill
extends ItemEnergy {
    private static final int ENERGY_USE = 100;
    private static final int HARVEST_LEVEL = 4;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] allDemDamnIconsMaan;

    public ItemDrill(String name) {
        super(500000, 5000, name);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.setHarvestLevel("shovel", 4);
        this.setHarvestLevel("pickaxe", 4);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return par1 >= this.allDemDamnIconsMaan.length ? null : this.allDemDamnIconsMaan[par1];
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int hitSide, float hitX, float hitY, float hitZ) {
        ItemStack anEquip;
        int slot;
        ItemStack upgrade = this.getHasUpgradeAsStack(stack, ItemDrillUpgrade.UpgradeType.PLACER);
        if (upgrade != null && (slot = ItemDrillUpgrade.getSlotToPlaceFrom(upgrade)) >= 0 && slot < InventoryPlayer.func_70451_h() && (anEquip = player.field_71071_by.func_70301_a(slot)) != null && anEquip != stack) {
            ItemStack equip = anEquip.func_77946_l();
            if (!world.field_72995_K) {
                try {
                    if (equip.func_77943_a(player, world, x, y, z, hitSide, hitX, hitY, hitZ)) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71071_by.func_70299_a(slot, equip.field_77994_a <= 0 ? null : equip.func_77946_l());
                        }
                        player.field_71069_bz.func_75142_b();
                        return true;
                    }
                }
                catch (Exception e) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Ouch! That really hurt! You must have done something wrong, don't do that again please!"));
                    ModUtil.LOGGER.error("Player " + player.func_70005_c_() + " who should place a Block using a Drill at " + player.field_70165_t + ", " + player.field_70163_u + ", " + player.field_70161_v + " in World " + world.field_73011_w.field_76574_g + " threw an Exception! Don't let that happen again!");
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public ItemStack getHasUpgradeAsStack(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return null;
        }
        ItemStack[] slots = this.getSlotsFromNBT(stack);
        if (slots != null && slots.length > 0) {
            for (ItemStack slotStack : slots) {
                if (slotStack == null || !(slotStack.func_77973_b() instanceof ItemDrillUpgrade) || ((ItemDrillUpgrade)slotStack.func_77973_b()).type != upgrade) continue;
                return slotStack;
            }
        }
        return null;
    }

    public ItemStack[] getSlotsFromNBT(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return null;
        }
        int slotAmount = compound.func_74762_e("SlotAmount");
        ItemStack[] slots = new ItemStack[slotAmount];
        if (slots.length > 0) {
            NBTTagList tagList = compound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                byte slotIndex = tagCompound.func_74771_c("Slot");
                if (slotIndex < 0 || slotIndex >= slots.length) continue;
                slots[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
            }
        }
        return slots;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af() && stack == player.func_71045_bC()) {
            player.openGui((Object)ActuallyAdditions.instance, GuiHandler.GuiTypes.DRILL.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity1, EntityLivingBase entity2) {
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            this.extractEnergy(stack, use, false);
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        ItemStack[] slots = this.getSlotsFromNBT(stack);
        if (slots != null && slots.length > 0) {
            for (ItemStack slotStack : slots) {
                int energy;
                if (slotStack == null || !(slotStack.func_77973_b() instanceof IEnergyContainerItem) || this.getEnergyStored(stack) >= this.getMaxEnergyStored(stack) || (energy = ((IEnergyContainerItem)slotStack.func_77973_b()).getEnergyStored(slotStack)) <= 0) continue;
                int toReceive = ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, energy, true);
                int actualReceive = ((IEnergyContainerItem)slotStack.func_77973_b()).extractEnergy(slotStack, toReceive, false);
                ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, actualReceive, false);
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconReg) {
        this.allDemDamnIconsMaan = new IIcon[16];
        for (int i = 0; i < this.allDemDamnIconsMaan.length; ++i) {
            this.allDemDamnIconsMaan[i] = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + TheColoredLampColors.values()[i].name);
        }
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap map = super.getAttributeModifiers(stack);
        map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Drill Modifier", this.getEnergyStored(stack) >= 100 ? 8.0 : (double)0.1f, 0));
        return map;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) ? (this.hasExtraWhitelist(block) || block.getHarvestTool(meta) == null || block.getHarvestTool(meta).isEmpty() || this.getToolClasses(stack).contains(block.getHarvestTool(meta)) ? this.getEfficiencyFromUpgrade(stack) : 1.0f) : 0.1f;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        boolean toReturn = false;
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
                ItemUtil.addEnchantment(stack, Enchantment.field_77348_q, 1);
            } else if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
                ItemUtil.addEnchantment(stack, Enchantment.field_77346_s, this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II) ? 3 : 1);
            }
            toReturn = !player.func_70093_af() && this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE) ? this.breakBlocks(stack, 2, player.field_70170_p, x, y, z, player) : this.breakBlocks(stack, 1, player.field_70170_p, x, y, z, player)) : this.breakBlocks(stack, 0, player.field_70170_p, x, y, z, player);
            ItemUtil.removeEnchantment(stack, Enchantment.field_77348_q);
            ItemUtil.removeEnchantment(stack, Enchantment.field_77346_s);
        }
        return toReturn;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        int harvestLevel = this.getHarvestLevel(stack, "");
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) && (this.hasExtraWhitelist(block) || block.func_149688_o().func_76229_l() || block == Blocks.field_150431_aC || block == Blocks.field_150433_aE || (block == Blocks.field_150343_Z ? harvestLevel >= 3 : (block != Blocks.field_150484_ah && block != Blocks.field_150482_ag ? (block != Blocks.field_150412_bA && block != Blocks.field_150475_bE ? (block != Blocks.field_150340_R && block != Blocks.field_150352_o ? (block != Blocks.field_150339_S && block != Blocks.field_150366_p ? (block != Blocks.field_150368_y && block != Blocks.field_150369_x ? (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay ? block.func_149688_o() == Material.field_151576_e || block.func_149688_o() == Material.field_151573_f || block.func_149688_o() == Material.field_151574_g : harvestLevel >= 2) : harvestLevel >= 1) : harvestLevel >= 1) : harvestLevel >= 2) : harvestLevel >= 2) : harvestLevel >= 2)));
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("pickaxe");
        hashSet.add("shovel");
        return hashSet;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return 4;
    }

    public int getEnergyUsePerBlock(ItemStack stack) {
        int use = 100;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            use += 50;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II)) {
                use += 75;
                if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III)) {
                    use += 175;
                }
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
            use += 100;
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
            use += 40;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II)) {
                use += 80;
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            use += 10;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                use += 30;
            }
        }
        return use;
    }

    public boolean getHasUpgrade(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        return this.getHasUpgradeAsStack(stack, upgrade) != null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i < this.allDemDamnIconsMaan.length; ++i) {
            this.addDrillStack(list, i);
        }
    }

    private void addDrillStack(List list, int meta) {
        ItemStack stackFull = new ItemStack((Item)this, 1, meta);
        this.setEnergy(stackFull, this.getMaxEnergyStored(stackFull));
        list.add(stackFull);
        ItemStack stackEmpty = new ItemStack((Item)this, 1, meta);
        this.setEnergy(stackEmpty, 0);
        list.add(stackEmpty);
    }

    public float getEfficiencyFromUpgrade(ItemStack stack) {
        float efficiency = 8.0f;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            efficiency = this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III) ? (efficiency += 37.0f) : (efficiency += 25.0f)) : (efficiency += 8.0f);
        }
        return efficiency;
    }

    public void writeSlotsToNBT(ItemStack[] slots, ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if (slots != null && slots.length > 0) {
            compound.func_74768_a("SlotAmount", slots.length);
            NBTTagList tagList = new NBTTagList();
            for (int currentIndex = 0; currentIndex < slots.length; ++currentIndex) {
                if (slots[currentIndex] == null) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)currentIndex);
                slots[currentIndex].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a("Items", (NBTBase)tagList);
        }
        stack.func_77982_d(compound);
    }

    public boolean breakBlocks(ItemStack stack, int radius, World world, int x, int y, int z, EntityPlayer player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        MovingObjectPosition pos = WorldUtil.getNearestBlockWithDefaultReachDistance(world, player);
        if (pos == null) {
            return false;
        }
        int side = pos.field_72310_e;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        float mainHardness = world.func_147439_a(x, y, z).func_149712_f(world, x, y, z);
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (!this.tryHarvestBlock(world, x, y, z, false, stack, player, use)) {
                return false;
            }
        } else {
            return false;
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (x == xPos && y == yPos && z == zPos) continue;
                        if (this.getEnergyStored(stack) >= use) {
                            if (!(world.func_147439_a(xPos, yPos, zPos).func_149712_f(world, xPos, yPos, zPos) <= mainHardness + 5.0f)) continue;
                            this.tryHarvestBlock(world, xPos, yPos, zPos, true, stack, player, use);
                            continue;
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean tryHarvestBlock(World world, int xPos, int yPos, int zPos, boolean isExtra, ItemStack stack, EntityPlayer player, int use) {
        boolean canHarvest;
        Block block = world.func_147439_a(xPos, yPos, zPos);
        float hardness = block.func_149712_f(world, xPos, yPos, zPos);
        int meta = world.func_72805_g(xPos, yPos, zPos);
        boolean bl = canHarvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) && !this.canHarvestBlock(block, stack) || isExtra && !(this.getDigSpeed(stack, block, meta) > 1.0f));
        if (hardness >= 0.0f && (!isExtra || canHarvest && !block.hasTileEntity(meta))) {
            this.extractEnergy(stack, use, false);
            return WorldUtil.playerHarvestBlock(world, xPos, yPos, zPos, player);
        }
        return false;
    }

    private boolean hasExtraWhitelist(Block block) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        if (name != null) {
            for (String list : ConfigValues.drillExtraminingWhitelist) {
                if (!list.equals(name)) continue;
                return true;
            }
        }
        return false;
    }
}

