/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.coffee.CoffeeBrewing;
import de.ellpeck.actuallyadditions.api.recipe.coffee.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemFoodBase;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class ItemCoffee
extends ItemFoodBase {
    public ItemCoffee(String name) {
        super(8, 5.0f, false, name);
        this.func_77656_e(3);
        this.func_77848_i();
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public static void initIngredients() {
        Item item;
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new MilkIngredient(new ItemStack(Items.field_151117_aB)));
        if (Loader.isModLoaded((String)"harvestcraft") && (item = ItemUtil.getItemFromName("harvestcraft:soymilkItem")) != null) {
            ActuallyAdditionsAPI.addCoffeeMachineIngredient(new MilkIngredient(new ItemStack(item)));
        }
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(new ItemStack(Items.field_151102_aT), new PotionEffect[]{new PotionEffect(Potion.field_76424_c.func_76396_c(), 30, 0)}, 4));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(new ItemStack(Items.field_151064_bs), new PotionEffect[]{new PotionEffect(Potion.field_76426_n.func_76396_c(), 20, 0)}, 2));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(new ItemStack(Items.field_151115_aP, 1, 3), new PotionEffect[]{new PotionEffect(Potion.field_76427_o.func_76396_c(), 10, 0)}, 2));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(new ItemStack(Items.field_151150_bK), new PotionEffect[]{new PotionEffect(Potion.field_76439_r.func_76396_c(), 30, 0)}, 2));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(new ItemStack(Items.field_151073_bk), new PotionEffect[]{new PotionEffect(Potion.field_76428_l.func_76396_c(), 5, 0)}, 3));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(new ItemStack(Items.field_151065_br), new PotionEffect[]{new PotionEffect(Potion.field_76420_g.func_76396_c(), 15, 0)}, 4));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(new ItemStack(Items.field_151071_bq), new PotionEffect[]{new PotionEffect(Potion.field_76441_p.func_76396_c(), 25, 0)}, 2));
    }

    public static CoffeeIngredient getIngredientFromStack(ItemStack stack) {
        for (CoffeeIngredient ingredient : ActuallyAdditionsAPI.coffeeMachineIngredients) {
            if (!ingredient.ingredient.func_77946_l().func_77969_a(stack)) continue;
            return ingredient;
        }
        return null;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        ItemStack theStack = stack.func_77946_l();
        super.func_77654_b(stack, world, player);
        ItemCoffee.applyPotionEffectsFromStack(stack, player);
        theStack.func_77964_b(theStack.func_77960_j() + 1);
        if (theStack.func_77958_k() - theStack.func_77960_j() < 0) {
            return new ItemStack(InitItems.itemMisc, 1, TheMiscItems.CUP.ordinal());
        }
        return theStack;
    }

    public static void applyPotionEffectsFromStack(ItemStack stack, EntityPlayer player) {
        PotionEffect[] effects = CoffeeBrewing.getEffectsFromStack(stack);
        if (effects != null && effects.length > 0) {
            for (PotionEffect effect : effects) {
                player.func_70690_d(new PotionEffect(effect.func_76456_a(), effect.func_76459_b() * 20, effect.func_76458_c()));
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.drink;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.field_77791_bV;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        PotionEffect[] effects = CoffeeBrewing.getEffectsFromStack(stack);
        if (effects != null) {
            for (PotionEffect effect : effects) {
                list.add(StringUtil.localize(effect.func_76453_d()) + " " + (effect.func_76458_c() + 1) + ", " + StringUtils.func_76337_a((int)(effect.func_76459_b() * 20)));
            }
        } else {
            list.add("No Effects");
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconReg) {
        this.field_77791_bV = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName());
    }

    public static class MilkIngredient
    extends CoffeeIngredient {
        public MilkIngredient(ItemStack ingredient) {
            super(ingredient, null, 0);
        }

        @Override
        public boolean effect(ItemStack stack) {
            PotionEffect[] effects = CoffeeBrewing.getEffectsFromStack(stack);
            ArrayList<PotionEffect> effectsNew = new ArrayList<PotionEffect>();
            if (effects != null && effects.length > 0) {
                for (PotionEffect effect : effects) {
                    if (effect.func_76458_c() <= 0) continue;
                    effectsNew.add(new PotionEffect(effect.func_76456_a(), effect.func_76459_b() + 120, effect.func_76458_c() - 1));
                }
                stack.func_77982_d(new NBTTagCompound());
                if (effectsNew.size() > 0) {
                    this.effects = effectsNew.toArray(new PotionEffect[effectsNew.size()]);
                    CoffeeBrewing.addEffectToStack(stack, this);
                }
            }
            this.effects = null;
            return true;
        }

        @Override
        public String getExtraText() {
            return StringUtil.localize("container.nei." + ModUtil.MOD_ID_LOWER + ".coffee.extra.milk");
        }
    }
}

