/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigCrafting;
import de.ellpeck.actuallyadditions.mod.crafting.ToolCrafting;
import de.ellpeck.actuallyadditions.mod.creative.CreativeTab;
import de.ellpeck.actuallyadditions.mod.items.base.ItemAllToolAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class InitForeignPaxels {
    public static final int[] MT_COLORS = new int[]{4166, 2248890, 8882649, 12410135, 11451392, 0x38383C};
    public static final String[] MT_NAMES = new String[]{"Obsidian", "LapisLazuli", "Osmium", "Bronze", "Glowstone", "Steel"};
    public static final int[] TF_COLORS = new int[]{13332762, 5407943, 5407895, 5394789, 12960613, 12960653, 12410135, 2999795, 10143162};
    public static final int[] SO_COLORS = new int[]{9409450, 2040021, 5714944, 526344, 545032};
    private static final String MEKANISM_TOOLS = "MekanismTools";
    private static final String[] MT_REPAIR_NAMES = new String[]{"ingotRefinedObsidian", "gemLapis", "ingotOsmium", "ingotBronze", "ingotRefinedGlowstone", "ingotSteel"};
    private static final String THERMAL_FOUNDATION = "ThermalFoundation";
    private static final String[] TF_NAMES = new String[]{"Copper", "Tin", "Silver", "Lead", "Nickel", "Electrum", "Bronze", "Platinum", "Invar"};
    private static final String SIMPLE_ORES = "simpleores";
    private static final String[] SO_NAMES = new String[]{"tin", "mythril", "copper", "onyx", "adamantium"};
    private static final String[] SO_REPAIR_NAMES = new String[]{"ingotTin", "ingotMythril", "ingotCopper", "gemOnyx", "ingotAdamantium"};
    public static Item[] tfPaxels = new Item[9];
    public static Item[] soPaxels = new Item[5];
    private static Item[] mtPaxels = new Item[6];

    public static void init() {
        Item.ToolMaterial material;
        Item shovel;
        Item sword;
        Item hoe;
        Item pickaxe;
        Item axe;
        int i;
        if (ConfigBoolValues.SO_PAXELS.isEnabled()) {
            if (Loader.isModLoaded((String)SIMPLE_ORES)) {
                ModUtil.LOGGER.info("Initializing simpleores AIOTs...");
                for (i = 0; i < soPaxels.length; ++i) {
                    axe = ItemUtil.getItemFromName("simpleores:" + SO_NAMES[i] + "_axe");
                    pickaxe = ItemUtil.getItemFromName("simpleores:" + SO_NAMES[i] + "_pickaxe");
                    hoe = ItemUtil.getItemFromName("simpleores:" + SO_NAMES[i] + "_hoe");
                    sword = ItemUtil.getItemFromName("simpleores:" + SO_NAMES[i] + "_sword");
                    shovel = ItemUtil.getItemFromName("simpleores:" + SO_NAMES[i] + "_shovel");
                    if (axe == null || pickaxe == null || hoe == null || sword == null || shovel == null || !(axe instanceof ItemTool)) continue;
                    material = ((ItemTool)axe).func_150913_i();
                    InitForeignPaxels.soPaxels[i] = new ItemAllToolAA(material, SO_REPAIR_NAMES[i], "paxelSO" + SO_NAMES[i], EnumRarity.rare, SO_COLORS[i]);
                    if (!ConfigCrafting.PAXELS.isEnabled()) continue;
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(soPaxels[i], new Object[]{axe, pickaxe, hoe, sword, shovel}));
                    ToolCrafting.recipesPaxels.add(Util.GetRecipes.lastIRecipe());
                }
            } else {
                ModUtil.LOGGER.info("simpleores not loaded, can't initialize Special AIOTs.");
            }
        }
        if (ConfigBoolValues.MT_PAXELS.isEnabled()) {
            if (Loader.isModLoaded((String)MEKANISM_TOOLS)) {
                ModUtil.LOGGER.info("Initializing MekanismTools AIOTs...");
                for (i = 0; i < mtPaxels.length; ++i) {
                    axe = ItemUtil.getItemFromName("MekanismTools:" + MT_NAMES[i] + "Axe");
                    pickaxe = ItemUtil.getItemFromName("MekanismTools:" + MT_NAMES[i] + "Pickaxe");
                    hoe = ItemUtil.getItemFromName("MekanismTools:" + MT_NAMES[i] + "Hoe");
                    sword = ItemUtil.getItemFromName("MekanismTools:" + MT_NAMES[i] + "Sword");
                    shovel = ItemUtil.getItemFromName("MekanismTools:" + MT_NAMES[i] + "Shovel");
                    if (axe == null || pickaxe == null || hoe == null || sword == null || shovel == null || !(axe instanceof ItemTool)) continue;
                    material = ((ItemTool)axe).func_150913_i();
                    InitForeignPaxels.mtPaxels[i] = new ItemAllToolAA(material, MT_REPAIR_NAMES[i], "paxelMT" + MT_NAMES[i], EnumRarity.rare, MT_COLORS[i]);
                    if (!ConfigCrafting.PAXELS.isEnabled()) continue;
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(mtPaxels[i], new Object[]{axe, pickaxe, hoe, sword, shovel}));
                    ToolCrafting.recipesPaxels.add(Util.GetRecipes.lastIRecipe());
                }
            } else {
                ModUtil.LOGGER.info("MekanismTools not loaded, can't initialize Special AIOTs.");
            }
        }
        if (ConfigBoolValues.TF_PAXELS.isEnabled()) {
            if (Loader.isModLoaded((String)THERMAL_FOUNDATION)) {
                ModUtil.LOGGER.info("Initializing ThermalFoundation AIOTs...");
                for (i = 0; i < tfPaxels.length; ++i) {
                    axe = ItemUtil.getItemFromName("ThermalFoundation:tool.axe" + TF_NAMES[i]);
                    pickaxe = ItemUtil.getItemFromName("ThermalFoundation:tool.pickaxe" + TF_NAMES[i]);
                    hoe = ItemUtil.getItemFromName("ThermalFoundation:tool.hoe" + TF_NAMES[i]);
                    sword = ItemUtil.getItemFromName("ThermalFoundation:tool.sword" + TF_NAMES[i]);
                    shovel = ItemUtil.getItemFromName("ThermalFoundation:tool.shovel" + TF_NAMES[i]);
                    if (axe == null || pickaxe == null || hoe == null || sword == null || shovel == null || !(axe instanceof ItemTool)) continue;
                    material = ((ItemTool)axe).func_150913_i();
                    InitForeignPaxels.tfPaxels[i] = new ItemAllToolAA(material, "ingot" + TF_NAMES[i], "paxelTF" + TF_NAMES[i], EnumRarity.rare, TF_COLORS[i]);
                    if (!ConfigCrafting.PAXELS.isEnabled()) continue;
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(tfPaxels[i], new Object[]{axe, pickaxe, hoe, sword, shovel}));
                    ToolCrafting.recipesPaxels.add(Util.GetRecipes.lastIRecipe());
                }
            } else {
                ModUtil.LOGGER.info("ThermalFoundation not loaded, can't initialize Special AIOTs.");
            }
        }
    }

    public static void addToCreativeTab() {
        for (Item item : tfPaxels) {
            if (item == null) continue;
            CreativeTab.instance.add(item);
        }
        for (Item item : mtPaxels) {
            if (item == null) continue;
            CreativeTab.instance.add(item);
        }
        for (Item item : soPaxels) {
            if (item == null) continue;
            CreativeTab.instance.add(item);
        }
    }
}

