/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.block.IHudDisplay;
import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.proxy.ClientProxy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomEnergyface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomItemface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomLiquiface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class BlockPhantom
extends BlockContainerBase
implements IHudDisplay {
    public Type type;
    public int range;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSeasonal;

    public BlockPhantom(Type type, String name) {
        super(Material.field_151576_e, name);
        this.type = type;
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(4.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149769_e);
        if (type == Type.FACE || type == Type.LIQUIFACE || type == Type.ENERGYFACE) {
            this.range = 16;
        } else if (type == Type.BREAKER || type == Type.PLACER) {
            this.range = 3;
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        if (this.type == Type.PLACER || this.type == Type.BREAKER) {
            this.dropInventory(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public TileEntity func_149915_a(World world, int par2) {
        switch (this.type) {
            case PLACER: {
                return new TileEntityPhantomPlacer();
            }
            case BREAKER: {
                return new TileEntityPhantomPlacer.TileEntityPhantomBreaker();
            }
            case LIQUIFACE: {
                return new TileEntityPhantomLiquiface();
            }
            case ENERGYFACE: {
                return new TileEntityPhantomEnergyface();
            }
        }
        return new TileEntityPhantomItemface();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.type == Type.FACE && ClientProxy.pumpkinBlurPumpkinBlur && side > 1 ? this.iconSeasonal : this.field_149761_L;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int hitSide, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (this.tryToggleRedstone(world, x, y, z, player)) {
            return true;
        }
        if (!world.field_72995_K && (tile = world.func_147438_o(x, y, z)) instanceof IPhantomTile && ((IPhantomTile)tile).getGuiID() != -1) {
            player.openGui((Object)ActuallyAdditions.instance, ((IPhantomTile)tile).getGuiID(), world, x, y, z);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        this.field_149761_L = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName());
        this.iconSeasonal = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":blockPhantomfacePumpkin");
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.epic;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayHud(Minecraft minecraft, EntityPlayer player, ItemStack stack, MovingObjectPosition posHit, Profiler profiler, ScaledResolution resolution) {
        TileEntity tile = minecraft.field_71441_e.func_147438_o(posHit.field_72311_b, posHit.field_72312_c, posHit.field_72309_d);
        if (tile != null && tile instanceof IPhantomTile) {
            IPhantomTile phantom = (IPhantomTile)tile;
            minecraft.field_71466_p.func_78261_a(EnumChatFormatting.GOLD + StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".blockPhantomRange.desc") + ": " + phantom.getRange(), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 - 40, 0xFFFFFF);
            if (phantom.hasBoundPosition()) {
                int distance = (int)Vec3.func_72443_a((double)posHit.field_72311_b, (double)posHit.field_72312_c, (double)posHit.field_72309_d).func_72438_d(Vec3.func_72443_a((double)phantom.getBoundPosition().getX(), (double)phantom.getBoundPosition().getY(), (double)phantom.getBoundPosition().getZ()));
                Item item = phantom.getBoundPosition().getItemBlock((World)minecraft.field_71441_e);
                String name = item == null ? "Absolutely Nothing" : item.func_77653_i(new ItemStack(phantom.getBoundPosition().getBlock((World)minecraft.field_71441_e), 1, phantom.getBoundPosition().getMetadata((World)minecraft.field_71441_e)));
                StringUtil.drawSplitString(minecraft.field_71466_p, StringUtil.localizeFormatted("tooltip." + ModUtil.MOD_ID_LOWER + ".phantom.blockInfo.desc", name, phantom.getBoundPosition().getX(), phantom.getBoundPosition().getY(), phantom.getBoundPosition().getZ(), distance), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 - 30, 200, 0xFFFFFF, true);
                if (phantom.isBoundThingInRange()) {
                    StringUtil.drawSplitString(minecraft.field_71466_p, EnumChatFormatting.DARK_GREEN + StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".phantom.connectedRange.desc"), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 + 25, 200, 0xFFFFFF, true);
                } else {
                    StringUtil.drawSplitString(minecraft.field_71466_p, EnumChatFormatting.DARK_RED + StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".phantom.connectedNoRange.desc"), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 + 25, 200, 0xFFFFFF, true);
                }
            } else {
                minecraft.field_71466_p.func_78261_a(EnumChatFormatting.RED + StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".phantom.notConnected.desc"), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 + 25, 0xFFFFFF);
            }
        }
    }

    public static enum Type {
        FACE,
        PLACER,
        BREAKER,
        LIQUIFACE,
        ENERGYFACE;

    }
}

