/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.block.IHudDisplay;
import de.ellpeck.actuallyadditions.api.lens.ILensItem;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAtomicReconstructor
extends BlockContainerBase
implements IHudDisplay {
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;

    public BlockAtomicReconstructor(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(10.0f);
        this.func_149752_b(80.0f);
        this.func_149672_a(field_149769_e);
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.epic;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int rotation = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, rotation, 2);
        super.func_149689_a(world, x, y, z, player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (side != meta && (side == 0 || side == 1)) {
            return this.topIcon;
        }
        if (side == meta) {
            return this.frontIcon;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.topIcon;
        }
        if (side == 3) {
            return this.frontIcon;
        }
        return this.field_149761_L;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityAtomicReconstructor reconstructor;
        if (this.tryToggleRedstone(world, x, y, z, player)) {
            return true;
        }
        if (!world.field_72995_K && (reconstructor = (TileEntityAtomicReconstructor)world.func_147438_o(x, y, z)) != null) {
            ItemStack heldItem = player.func_71045_bC();
            if (heldItem != null) {
                if (heldItem.func_77973_b() instanceof ILensItem && reconstructor.func_70301_a(0) == null) {
                    ItemStack toPut = heldItem.func_77946_l();
                    toPut.field_77994_a = 1;
                    reconstructor.func_70299_a(0, toPut);
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
            } else if (reconstructor.func_70301_a(0) != null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, reconstructor.func_70301_a(0).func_77946_l());
                reconstructor.func_70299_a(0, null);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        this.field_149761_L = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName());
        this.frontIcon = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + "Front");
        this.topIcon = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + "Top");
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityAtomicReconstructor();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        this.dropInventory(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, par6);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayHud(Minecraft minecraft, EntityPlayer player, ItemStack stack, MovingObjectPosition posHit, Profiler profiler, ScaledResolution resolution) {
        TileEntity tile = minecraft.field_71441_e.func_147438_o(posHit.field_72311_b, posHit.field_72312_c, posHit.field_72309_d);
        if (tile instanceof TileEntityAtomicReconstructor) {
            String strg;
            ItemStack slot = ((TileEntityAtomicReconstructor)tile).func_70301_a(0);
            if (slot == null) {
                strg = StringUtil.localize("info." + ModUtil.MOD_ID_LOWER + ".noLens");
            } else {
                strg = slot.func_77973_b().func_77653_i(slot);
                AssetUtil.renderStackToGui(slot, resolution.func_78326_a() / 2 + 15, resolution.func_78328_b() / 2 - 29, 1.0f);
            }
            minecraft.field_71466_p.func_78261_a(EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + strg, resolution.func_78326_a() / 2 + 35, resolution.func_78328_b() / 2 - 25, 0xFFFFFF);
        }
    }
}

