/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.VegaSystem;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import galaxyspace.GalaxySpace;
import galaxyspace.api.IBodiesHandler;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.systems.VegaSystem.core.configs.VGConfigCore;
import galaxyspace.systems.VegaSystem.core.configs.VGConfigDimensions;
import galaxyspace.systems.VegaSystem.core.registers.blocks.VGBlocks;
import galaxyspace.systems.VegaSystem.planets.vegaB.dimension.WorldProviderVegaB;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import net.minecraft.util.ResourceLocation;

public class VegaSystemBodies
implements IBodiesHandler {
    public static SolarSystem vegaSystem;
    public static Star Vega;
    public static Planet planetVega1;
    public static Planet planetVega2;
    public static Planet planetVegaasteroids;
    public static Planet planetVegaasteroids2;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new VGConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/vega/core.conf"));
        new VGConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/vega/dimensions.conf"));
        if (VGConfigCore.enableVegaSystem) {
            VGBlocks.initialize();
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        vegaSystem = new SolarSystem("vega", "milkyWay").setMapPosition(new Vector3(-1.5, -3.5, 0.0));
        Vega = (Star)new Star("Vega").setParentSolarSystem(vegaSystem).setTierRequired(-1);
        Vega.setBodyIcon(new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/celestialbodies/vega/Vega.png"));
        vegaSystem.setMainStar(Vega);
        planetVega1 = new Planet("Vega1").setParentSolarSystem(vegaSystem);
        planetVega1.setRingColorRGB(0.0f, 0.4f, 0.9f);
        planetVega1.setPhaseShift((float)Math.PI);
        planetVega1.setTierRequired(8);
        planetVega1.setBodyIcon(new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/celestialbodies/vega/Vega1.png"));
        planetVega1.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f));
        planetVega1.setRelativeOrbitTime(1.8619934f);
        planetVega1.setDimensionInfo(VGConfigDimensions.dimensionIDVegaB, WorldProviderVegaB.class);
        planetVegaasteroids = new Planet("VegaAsteroids").setParentSolarSystem(vegaSystem);
        planetVegaasteroids.setRingColorRGB(1.1f, 0.0f, 0.0f);
        planetVegaasteroids.setPhaseShift(0.7853982f);
        planetVegaasteroids.setBodyIcon(new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/celestialbodies/vega/VegaAsteroids.png"));
        planetVegaasteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.6f, 1.0f));
        planetVegaasteroids.setRelativeOrbitTime(11.861994f);
        planetVega2 = new Planet("Vega2").setParentSolarSystem(vegaSystem);
        planetVega2.setRingColorRGB(0.0f, 0.4f, 0.9f);
        planetVega2.setPhaseShift(1.5707964f);
        planetVega2.setBodyIcon(new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/celestialbodies/vega/Vega2.png"));
        planetVega2.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        planetVega2.setRelativeOrbitTime(5.8619933f);
        planetVegaasteroids2 = new Planet("VegaAsteroids2").setParentSolarSystem(vegaSystem);
        planetVegaasteroids2.setRingColorRGB(1.1f, 0.0f, 0.0f);
        planetVegaasteroids2.setPhaseShift(0.3926991f);
        planetVegaasteroids2.setBodyIcon(new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/celestialbodies/vega/VegaAsteroids.png"));
        planetVegaasteroids2.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.5f, 2.5f));
        planetVegaasteroids2.setRelativeOrbitTime(11.861994f);
        VegaSystemBodies.registrycelestial();
        VegaSystemBodies.registryteleport();
    }

    private static void registrycelestial() {
        if (VGConfigCore.enableVegaSystem) {
            GalaxyRegistry.registerSolarSystem((SolarSystem)vegaSystem);
            if (VGConfigDimensions.enableVegaB) {
                GalaxyRegistry.registerPlanet((Planet)planetVega1);
            }
            if (GSConfigCore.enableUnreachable) {
                GalaxyRegistry.registerPlanet((Planet)planetVega2);
                GalaxyRegistry.registerPlanet((Planet)planetVegaasteroids);
                GalaxyRegistry.registerPlanet((Planet)planetVegaasteroids2);
            }
        }
    }

    private static void registryteleport() {
        if (VGConfigDimensions.enableVegaB) {
            GalacticraftRegistry.registerTeleportType(WorldProviderVegaB.class, (ITeleportType)new WorldProviderVegaB());
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }
}

