/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.TCetiSystem;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import galaxyspace.GalaxySpace;
import galaxyspace.api.BodiesHelper;
import galaxyspace.api.IBodiesHandler;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.systems.TCetiSystem.core.configs.TCConfigCore;
import galaxyspace.systems.TCetiSystem.core.configs.TCConfigDimensions;
import galaxyspace.systems.TCetiSystem.core.registers.blocks.TCBlocks;
import galaxyspace.systems.TCetiSystem.planets.tcetiF.dimension.WorldProviderTCetiF;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;

public class TauCetiSystemBodies
implements IBodiesHandler {
    public static SolarSystem tcetiSystem;
    public static Star TCetiA;
    public static Planet tcetiE;
    public static Planet tcetiF;
    public static Planet tcetiG;
    public static Planet tcetiH;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new TCConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/tau_ceti/core.conf"));
        new TCConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/tau_ceti/dimensions.conf"));
        if (TCConfigCore.enableTauCetiSystem) {
            TCBlocks.initialize();
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        tcetiSystem = BodiesHelper.registerSolarSystem(GalaxySpace.ASSET_PREFIX, "tauceti", BodiesHelper.Galaxies.MILKYWAY, new Vector3(-2.0, 1.0, 0.0), "TauCetiA", 1.2f);
        tcetiG = BodiesHelper.registerPlanet(tcetiSystem, "TauCetiG", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.0471976f, 1.0f, 0.25f, 2.3f);
        tcetiH = BodiesHelper.registerPlanet(tcetiSystem, "TauCetiH", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.5707964f, 1.0f, 0.75f, 15.0f);
        tcetiE = BodiesHelper.registerPlanet(tcetiSystem, "TauCetiE", GalaxySpace.ASSET_PREFIX, null, -1, -1, (float)Math.PI, 1.0f, 1.25f, 30.0f);
        tcetiF = BodiesHelper.registerPlanet(tcetiSystem, "TauCetiF", GalaxySpace.ASSET_PREFIX, WorldProviderTCetiF.class, TCConfigDimensions.dimensionIDTauCetiF, 6, 1.0471976f, 1.0f, 1.5f, 60.0f);
        tcetiF.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.ARGON).atmosphereComponent(IAtmosphericGas.OXYGEN);
        TauCetiSystemBodies.registrycelestial();
        TauCetiSystemBodies.registryteleport();
    }

    private static void registrycelestial() {
        if (TCConfigCore.enableTauCetiSystem) {
            GalaxyRegistry.registerSolarSystem((SolarSystem)tcetiSystem);
            if (TCConfigDimensions.enableTauCetiF) {
                BodiesHelper.BodiesData data = new BodiesHelper.BodiesData(BodiesHelper.oceanide, BodiesHelper.calculateGravity(8.88f), 0, 0.0f, 1.0f, 28000L, false, false);
                BodiesHelper.registerBody((CelestialBody)tcetiF, data, true);
            }
            if (GSConfigCore.enableUnreachable) {
                GalaxyRegistry.registerPlanet((Planet)tcetiG);
                GalaxyRegistry.registerPlanet((Planet)tcetiH);
                GalaxyRegistry.registerPlanet((Planet)tcetiE);
            }
        }
    }

    private static void registryteleport() {
        if (TCConfigCore.enableTauCetiSystem) {
            GalacticraftRegistry.registerTeleportType(WorldProviderTCetiF.class, (ITeleportType)new WorldProviderTCetiF());
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }
}

