/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.satellites.venus.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.satellites.venus.dimension.ChunkProviderVenusSS;
import galaxyspace.systems.SolarSystem.satellites.venus.dimension.WorldChunkManagerVenusSS;
import galaxyspace.systems.SolarSystem.satellites.venus.dimension.sky.SkyProviderVenusSS;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderVenusSS
extends WorldProviderSpaceStation
implements IAdvancedSpace,
IOrbitDimension,
IZeroGDimension,
ISolarLevel,
IExitHeight {
    public int spaceStationDimensionID;

    public void setDimension(int var1) {
        this.spaceStationDimensionID = var1;
        super.setDimension(var1);
    }

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.venusSpaceStation;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 24000L;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderVenusSS.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerVenusSS.class;
    }

    public boolean isDaytime() {
        float a = this.field_76579_a.func_72826_c(0.0f);
        return a < 0.42f || a > 0.58f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 64;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public boolean func_76569_d() {
        return this.field_76579_a == null ? false : this.field_76579_a.field_72995_K;
    }

    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return this.shouldForceRespawn() ? this.field_76574_g : 0;
    }

    public String func_80007_l() {
        return "Space Station " + this.spaceStationDimensionID;
    }

    public float getGravity() {
        return 0.075f;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    public String getPlanetToOrbit() {
        return SolarSystemBodies.planetVenus.getUnlocalizedName();
    }

    public int getYCoordToTeleportToPlanet() {
        return 30;
    }

    public String getSaveFolder() {
        return "DIM_SPACESTATION" + this.spaceStationDimensionID;
    }

    public double getSolarEnergyMultiplier() {
        return ConfigManagerCore.spaceStationEnergyScalar;
    }

    public double getYCoordinateToTeleport() {
        return 1200.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier > SolarSystemBodies.planetVenus.getTierRequirement();
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    public float getThermalLevelModifier() {
        return 2.0f;
    }

    public float getWindLevel() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSpinDeltaPerTick(float angle) {
        SkyProviderVenusSS skyProvider = (SkyProviderVenusSS)this.getSkyRenderer();
        if (skyProvider != null) {
            skyProvider.spinDeltaPerTick = angle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void createSkyProvider() {
        this.setSkyRenderer(new SkyProviderVenusSS());
        this.setSpinDeltaPerTick(this.getSpinManager().getSpinRate());
        if (this.getCloudRenderer() == null) {
            this.setCloudRenderer((IRenderHandler)new CloudRenderer());
        }
    }

    @Override
    public int AtmosphericPressure() {
        return 0;
    }

    @Override
    public boolean SolarRadiation() {
        return true;
    }

    @Override
    public double getSolarWindMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = 1.0f / this.getCelestialBody().getRelativeDistanceFromCenter().unScaledDistance;
            solarMultiplier = s * s;
        }
        return solarMultiplier;
    }

    @Override
    public IAdvancedSpace.ClassBody getClassBody() {
        return IAdvancedSpace.ClassBody.SPACESTATION;
    }
}

