/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.venus.dimension.sky;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class WeatherProviderVenus
extends IRenderHandler {
    private static final ResourceLocation locationRainPng = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation locationSnowPng = new ResourceLocation("textures/environment/snow.png");
    float[] rainXCoords;
    float[] rainYCoords;
    private int rendererUpdateCount;
    private Random random = new Random();

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        ++this.rendererUpdateCount;
        this.renderNormalWeather(partialTicks, mc);
    }

    private void renderNormalWeather(float partialTicks, Minecraft mc) {
        float rainStrength = mc.field_71441_e.func_72867_j(partialTicks);
        if (rainStrength > 0.0f) {
            mc.field_71460_t.func_78463_b((double)partialTicks);
            this.initializeRainCoords();
            EntityLivingBase entitylivingbase = mc.field_71451_h;
            WorldClient worldclient = mc.field_71441_e;
            int k2 = MathHelper.func_76128_c((double)entitylivingbase.field_70165_t);
            int l2 = MathHelper.func_76128_c((double)entitylivingbase.field_70163_u);
            int i3 = MathHelper.func_76128_c((double)entitylivingbase.field_70161_v);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            double d0 = entitylivingbase.field_70142_S + (entitylivingbase.field_70165_t - entitylivingbase.field_70142_S) * (double)partialTicks;
            double d1 = entitylivingbase.field_70137_T + (entitylivingbase.field_70163_u - entitylivingbase.field_70137_T) * (double)partialTicks;
            double d2 = entitylivingbase.field_70136_U + (entitylivingbase.field_70161_v - entitylivingbase.field_70136_U) * (double)partialTicks;
            int k = MathHelper.func_76128_c((double)d1);
            int range = 4;
            if (mc.field_71474_y.field_74347_j) {
                range = 8;
            }
            int b1 = -1;
            float f5 = (float)this.rendererUpdateCount + partialTicks;
            if (mc.field_71474_y.field_74347_j) {
                range = 10;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int l = i3 - range; l <= i3 + range; ++l) {
                for (int i1 = k2 - range; i1 <= k2 + range; ++i1) {
                    int j1 = (l - i3 + 16) * 32 + i1 - k2 + 16;
                    float f6 = this.rainXCoords[j1] * 0.5f;
                    float f7 = this.rainYCoords[j1] * 0.5f;
                    BiomeGenBase biomegenbase = worldclient.func_72807_a(i1, l);
                    if (!biomegenbase.func_76738_d() && !biomegenbase.func_76746_c()) continue;
                    int yHeight = worldclient.func_72874_g(i1, l) + 9 - (int)(4.8f * rainStrength);
                    int y = l2 - range;
                    int yMax = l2 + range;
                    if (y < yHeight) {
                        y = yHeight;
                    }
                    if (yMax < yHeight) {
                        yMax = yHeight;
                    }
                    float f8 = 1.0f;
                    int yBase = yHeight;
                    if (yHeight < k) {
                        yBase = k;
                    }
                    if (y == yMax) continue;
                    this.random.setSeed(i1 * i1 * 3121 + i1 * 45238971 ^ l * l * 418711 + l * 13761);
                    float f9 = biomegenbase.func_150564_a(i1, y, l);
                    if (b1 != 0) {
                        if (b1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        b1 = 0;
                        mc.func_110434_K().func_110577_a(locationRainPng);
                        tessellator.func_78382_b();
                    }
                    float speed = f5 / 2.0f;
                    float downwardsMotion = ((float)((int)speed + i1 * i1 * 3121 + i1 * 45238971 + l * l * 418711 + l * 13761 & 0x1F) + partialTicks) / 32.0f * (1.0f + this.random.nextFloat());
                    double yo = this.random.nextDouble() / 1.8;
                    double d3 = (double)((float)i1 + 0.5f) - entitylivingbase.field_70165_t;
                    double xDist = (double)((float)l + 0.5f) - entitylivingbase.field_70161_v;
                    float f12 = MathHelper.func_76133_a((double)(d3 * d3 + xDist * xDist)) / (float)range;
                    tessellator.func_78380_c(worldclient.func_72802_i(i1, yBase, l, 0));
                    tessellator.func_78369_a(1.0f, 0.5f, 0.0f, ((1.0f - f12 * f12) * 0.5f + 0.5f) * rainStrength);
                    tessellator.func_78373_b(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                    tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)y - yo, (double)((float)l - f7) + 0.5, (double)(0.0f * f8), (double)((float)y * f8 / 4.0f + downwardsMotion * f8));
                    tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)y - yo, (double)((float)l + f7) + 0.5, (double)(1.0f * f8), (double)((float)y * f8 / 4.0f + downwardsMotion * f8));
                    tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)yMax - yo, (double)((float)l + f7) + 0.5, (double)(1.0f * f8), (double)((float)yMax * f8 / 4.0f + downwardsMotion * f8));
                    tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)yMax - yo, (double)((float)l - f7) + 0.5, (double)(0.0f * f8), (double)((float)yMax * f8 / 4.0f + downwardsMotion * f8));
                }
            }
            if (b1 >= 0) {
                tessellator.func_78381_a();
            }
            tessellator.func_78373_b(0.0, 0.0, 0.0);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            mc.field_71460_t.func_78483_a((double)partialTicks);
        }
    }

    private void initializeRainCoords() {
        if (this.rainXCoords == null) {
            this.rainXCoords = new float[1024];
            this.rainYCoords = new float[1024];
            for (int i = 0; i < 32; ++i) {
                float f1 = i - 16;
                for (int j = 0; j < 32; ++j) {
                    float f = j - 16;
                    float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                    this.rainXCoords[i << 5 | j] = -f1 / f2;
                    this.rainYCoords[i << 5 | j] = f / f2;
                }
            }
        }
    }
}

